/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.build.ant.tasks;

import java.io.*;
import java.util.*;

import org.apache.tools.ant.*;
import org.apache.tools.ant.types.Path;

public class GenerateOsgiDotBundles extends Task {
	private File launcherFile;
	private String propertyName;
	private Path bundlesPath;

	public void setPropertyName(String propertyName) {
		this.propertyName = propertyName;
	}

	public void setLauncherFile(File launcherFile) {
		this.launcherFile = launcherFile;
	}

	public Path createBundlesPath() {
		bundlesPath = new Path(getProject());
		return bundlesPath;
	}

	private void checkArguments() throws BuildException {
		if (launcherFile == null)
			throw new BuildException("The launcherFile is mandatory");
		if (propertyName == null)
			throw new BuildException("The propertyName is mandatory");
		if (bundlesPath == null)
			throw new BuildException("The bundlesPath is mandatory");
	}

	private String getLauncherSettingValue(String fileLine, String attributeName) {
		return fileLine.trim().substring(("<stringAttribute key=\"" + attributeName + "\" value=\"").length(),
				fileLine.trim().length() - "\"/>".length());
	}

	private void checkBundlesList(String line, StringBuffer bundlesStringBuffer, String attributeName) {
		if (line.indexOf(attributeName) != -1) {
			if (bundlesStringBuffer.length() != 0) {
				bundlesStringBuffer.append(',');
			}
			bundlesStringBuffer.append(getLauncherSettingValue(line, attributeName));
		}
	}

	private String[] getLauncherBundles() {
		BufferedReader reader = null;
		try {
			reader = new BufferedReader(new FileReader(launcherFile));
			String line;
			StringBuffer bundlesStringBuffer = new StringBuffer();
			while ((line = reader.readLine()) != null) {
				checkBundlesList(line, bundlesStringBuffer, "target_bundles");
				checkBundlesList(line, bundlesStringBuffer, "workspace_bundles");
			}
			String[] bundles = bundlesStringBuffer.toString().split(",");
			return bundles;
		} catch (FileNotFoundException e) {
			throw new BuildException("The launcher file " + launcherFile + " doesn't exist", e);
		} catch (IOException e) {
			throw new BuildException("The launcher file " + launcherFile + " cannot be read", e);
		} finally {
			if (reader != null)
				try {
					reader.close();
				} catch (IOException e) {
				}
		}
	}

	private File getFileNameStartingWith(List<File> files, String prefix) {
		for (File file : files) {
			if (file.getName().startsWith(prefix)) {
				return file;
			}
		}
		return null;
	}

	@Override
	public void execute() throws BuildException {
		try {
			checkArguments();

			String[] bundleDirNames = bundlesPath.list();
			List<File> bundleFiles = new LinkedList<File>();
			for (int i = 0; i < bundleDirNames.length; i++) {
				File[] entries = new File(bundleDirNames[i]).listFiles();
				if (entries != null)
					bundleFiles.addAll(Arrays.asList(entries));
			}

			String[] launcherBundles = getLauncherBundles();
			Arrays.sort(launcherBundles);

			StringBuffer osgiBundles = new StringBuffer();
			for (int i = 0; i < launcherBundles.length; i++) {
				int indexOfAt = launcherBundles[i].indexOf('@');
				String launcherBundleName = launcherBundles[i].substring(0, indexOfAt);
				if (launcherBundleName.equals("org.eclipse.osgi")) {
					log("Ignoring org.eclipse.osgi", Project.MSG_INFO);
					continue;
				}

				File bundleFile = getFileNameStartingWith(bundleFiles, launcherBundleName + '_');
				if (bundleFile == null) {
					log("No bundle file found for " + launcherBundleName, Project.MSG_WARN);
				} else {
					if (osgiBundles.length() != 0) {
						osgiBundles.append(",");
						//osgiBundles.append(",\\\n");
					}
					String startupInfo = launcherBundles[i].substring(indexOfAt + 1);
					startupInfo = startupInfo.replace("default:", "");
					startupInfo = startupInfo.replace("default", "start");
					startupInfo = startupInfo.replace("true", "start");
					startupInfo = startupInfo.replace("false", "");
					if (startupInfo.length() != 0)
						startupInfo = '@' + startupInfo;

					osgiBundles.append(bundleFile.getName() + startupInfo);
				}
			}

			getProject().setInheritedProperty(propertyName, osgiBundles.toString());
		} catch (BuildException e) {
			throw e;
		} catch (Exception e) {
			StringWriter sw = new StringWriter();
			e.printStackTrace(new PrintWriter(sw));
			log("Unexpected exception: " + e.getClass().getCanonicalName() + "\n" + sw, e, Project.MSG_ERR);
			throw new BuildException("Unexpected exception", e);
		}
	}
}
