/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.build.ant.tasks;

import java.util.*;

import org.apache.tools.ant.*;
import org.apache.tools.ant.types.Path;

import com.openexchange.build.ant.data.ProjectSetFileReader;

public class CreateProjectList extends Task {
	private Path projectSets;
	private String name;

	public final void setName(final String name) {
		this.name = name;
	}

	public final Path createProjectSets() {
		projectSets = new Path(getProject());
		return projectSets;
	}

	@Override
	public final void execute() throws BuildException {
		String[] projectSetFiles = projectSets.list();
		Map<String, String> projects = new HashMap<String, String>();
		for (int i = 0; i < projectSetFiles.length; i++) {
			log("parsing " + projectSetFiles[i], Project.MSG_INFO);
			projects.putAll(ProjectSetFileReader.parse(projectSetFiles[i]));
		}

		String projectNamesList = getProjectNamesList(projects.keySet());
		log(name + "=" + projectNamesList, Project.MSG_INFO);
		getProject().setInheritedProperty(name, projectNamesList);

		for (Map.Entry<String, String> entry : projects.entrySet()) {
			String projectName = entry.getKey();
			String projectSvnUrl = entry.getValue();
			getProject().setInheritedProperty(projectName + ".svn.url",
					projectSvnUrl);
		}
	}

	public String getProjectNamesList(Set<String> projects) {
		StringBuffer buffer = new StringBuffer();
		for (Iterator<String> it = projects.iterator(); it.hasNext();) {
			buffer.append(it.next());
			if (it.hasNext())
				buffer.append(',');
		}
		return buffer.toString();
	}
}
