/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTDoStatement;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTTryStatement;
import net.sourceforge.pmd.ast.ASTVariableInitializer;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableField
extends AbstractRule {
    private static final int MUTABLE = 0;
    private static final int IMMUTABLE = 1;
    private static final int CHECKDECL = 2;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTWhileStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTVariableInitializer;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTDoStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTTryStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTForStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Map<VariableNameDeclaration, List<NameOccurrence>> vars = node.getScope().getVariableDeclarations();
        List<ASTConstructorDeclaration> constructors = this.findAllConstructors(node);
        for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> entry : vars.entrySet()) {
            int result;
            VariableNameDeclaration field = entry.getKey();
            if (field.getAccessNodeParent().isStatic() || !field.getAccessNodeParent().isPrivate() || field.getAccessNodeParent().isFinal() || field.getAccessNodeParent().isVolatile() || (result = this.initializedInConstructor(entry.getValue(), new HashSet<ASTConstructorDeclaration>(constructors))) == 0 || result != 1 && (result != 2 || !this.initializedWhenDeclared(field))) continue;
            this.addViolation(data, field.getNode(), field.getImage());
        }
        return super.visit(node, data);
    }

    private boolean initializedWhenDeclared(VariableNameDeclaration field) {
        AccessNode accessNode = field.getAccessNodeParent();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableInitializer;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableInitializer = new ASTVariableInitializer[0].getClass().getComponentType();
        }
        return !accessNode.findChildrenOfType(clazz).isEmpty();
    }

    private int initializedInConstructor(List<NameOccurrence> usages, Set<ASTConstructorDeclaration> allConstructors) {
        int result = 0;
        int methodInitCount = 0;
        HashSet<ASTConstructorDeclaration> consSet = new HashSet<ASTConstructorDeclaration>();
        for (NameOccurrence occ : usages) {
            ASTConstructorDeclaration constructor;
            if (!occ.isOnLeftHandSide() && !occ.isSelfAssignment()) continue;
            SimpleNode node = occ.getLocation();
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
            if (clazz == null) {
                clazz = new ASTConstructorDeclaration[0].getClass().getComponentType();
            }
            if ((constructor = (ASTConstructorDeclaration)node.getFirstParentOfType(clazz)) != null) {
                if (this.inLoopOrTry(node)) continue;
                if (this.inAnonymousInnerClass(node)) {
                    ++methodInitCount;
                    continue;
                }
                consSet.add(constructor);
                continue;
            }
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
            if (clazz2 == null) {
                clazz2 = new ASTMethodDeclaration[0].getClass().getComponentType();
            }
            if (node.getFirstParentOfType(clazz2) == null) continue;
            ++methodInitCount;
        }
        if (usages.isEmpty() || methodInitCount == 0 && consSet.isEmpty()) {
            result = 2;
        } else {
            allConstructors.removeAll(consSet);
            if (allConstructors.isEmpty() && methodInitCount == 0) {
                result = 1;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inLoopOrTry(SimpleNode node) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTTryStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTTryStatement = new ASTTryStatement[0].getClass().getComponentType();
        }
        if (node.getFirstParentOfType(clazz) != null) return true;
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTForStatement;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTForStatement = new ASTForStatement[0].getClass().getComponentType();
        }
        if (node.getFirstParentOfType(clazz2) != null) return true;
        Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTWhileStatement;
        if (clazz3 == null) {
            clazz3 = class$net$sourceforge$pmd$ast$ASTWhileStatement = new ASTWhileStatement[0].getClass().getComponentType();
        }
        if (node.getFirstParentOfType(clazz3) != null) return true;
        Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTDoStatement;
        if (clazz4 == null) {
            clazz4 = class$net$sourceforge$pmd$ast$ASTDoStatement = new ASTDoStatement[0].getClass().getComponentType();
        }
        if (node.getFirstParentOfType(clazz4) == null) return false;
        return true;
    }

    private boolean inAnonymousInnerClass(SimpleNode node) {
        ASTClassOrInterfaceBodyDeclaration parent;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration = new ASTClassOrInterfaceBodyDeclaration[0].getClass().getComponentType();
        }
        return (parent = (ASTClassOrInterfaceBodyDeclaration)node.getFirstParentOfType(clazz)) != null && parent.isAnonymousInnerClass();
    }

    private List<ASTConstructorDeclaration> findAllConstructors(ASTClassOrInterfaceDeclaration node) {
        ArrayList<ASTConstructorDeclaration> cons = new ArrayList<ASTConstructorDeclaration>();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTConstructorDeclaration = new ASTConstructorDeclaration[0].getClass().getComponentType();
        }
        node.findChildrenOfType(clazz, cons, false);
        return cons;
    }
}

