/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.AbstractRenderer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OnTheFlyRenderer
extends AbstractRenderer {
    protected List<Report.ProcessingError> errors = new LinkedList<Report.ProcessingError>();
    protected List<Report.SuppressedViolation> suppressed = new LinkedList<Report.SuppressedViolation>();

    @Override
    public void render(Writer writer, Report report) throws IOException {
        this.setWriter(writer);
        this.start();
        this.renderFileReport(report);
        this.end();
    }

    @Override
    public void renderFileReport(Report report) throws IOException {
        Iterator<IRuleViolation> violations = report.iterator();
        if (violations.hasNext()) {
            this.renderFileViolations(violations);
        }
        Iterator<Report.ProcessingError> i = report.errors();
        while (i.hasNext()) {
            this.errors.add(i.next());
        }
        if (this.showSuppressedViolations) {
            this.suppressed.addAll(report.getSuppressedRuleViolations());
        }
    }

    @Override
    public abstract void start() throws IOException;

    public abstract void renderFileViolations(Iterator<IRuleViolation> var1) throws IOException;

    @Override
    public abstract void end() throws IOException;
}

