/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.jaxen;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sourceforge.pmd.ast.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class NodeIterator
implements Iterator<Node> {
    private Node node;

    public NodeIterator(Node contextNode) {
        this.node = this.getFirstNode(contextNode);
    }

    @Override
    public boolean hasNext() {
        return this.node != null;
    }

    @Override
    public Node next() {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        Node ret = this.node;
        this.node = this.getNextNode(this.node);
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract Node getFirstNode(Node var1);

    protected abstract Node getNextNode(Node var1);

    protected Node getPreviousSibling(Node contextNode) {
        int prevPosition;
        Node parentNode = contextNode.jjtGetParent();
        if (parentNode != null && (prevPosition = this.getPositionFromParent(contextNode) - 1) >= 0) {
            return parentNode.jjtGetChild(prevPosition);
        }
        return null;
    }

    private int getPositionFromParent(Node contextNode) {
        Node parentNode = contextNode.jjtGetParent();
        for (int i = 0; i < parentNode.jjtGetNumChildren(); ++i) {
            if (parentNode.jjtGetChild(i) != contextNode) continue;
            return i;
        }
        throw new RuntimeException("Node was not a child of it's parent ???");
    }

    protected Node getNextSibling(Node contextNode) {
        int nextPosition;
        Node parentNode = contextNode.jjtGetParent();
        if (parentNode != null && (nextPosition = this.getPositionFromParent(contextNode) + 1) < parentNode.jjtGetNumChildren()) {
            return parentNode.jjtGetChild(nextPosition);
        }
        return null;
    }

    protected Node getFirstChild(Node contextNode) {
        if (contextNode.jjtGetNumChildren() > 0) {
            return contextNode.jjtGetChild(0);
        }
        return null;
    }

    protected Node getLastChild(Node contextNode) {
        if (contextNode.jjtGetNumChildren() > 0) {
            return contextNode.jjtGetChild(contextNode.jjtGetNumChildren() - 1);
        }
        return null;
    }

    @Override
    public Object next() {
        return this.next();
    }
}

