/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.TokenEntry;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Match
implements Comparable<Match> {
    private int tokenCount;
    private int lineCount;
    private Set<TokenEntry> markSet = new TreeSet<TokenEntry>();
    private TokenEntry[] marks = new TokenEntry[2];
    private String code;
    private MatchCode mc;
    private String label;
    public static final Comparator<Match> MatchesComparator = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            return mb.getMarkCount() - ma.getMarkCount();
        }

        @Override
        public int compare(Object x0, Object x1) {
            return this.compare((Match)x0, (Match)x1);
        }
    };
    public static final Comparator<Match> LinesComparator = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            return mb.getLineCount() - ma.getLineCount();
        }

        @Override
        public int compare(Object x0, Object x1) {
            return this.compare((Match)x0, (Match)x1);
        }
    };
    public static final Comparator<Match> LabelComparator = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            if (ma.getLabel() == null) {
                return 1;
            }
            if (mb.getLabel() == null) {
                return -1;
            }
            return mb.getLabel().compareTo(ma.getLabel());
        }

        @Override
        public int compare(Object x0, Object x1) {
            return this.compare((Match)x0, (Match)x1);
        }
    };
    public static final Comparator<Match> LengthComparator = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            return mb.getLineCount() - ma.getLineCount();
        }

        @Override
        public int compare(Object x0, Object x1) {
            return this.compare((Match)x0, (Match)x1);
        }
    };

    public Match(int tokenCount, TokenEntry first, TokenEntry second) {
        this.markSet.add(first);
        this.markSet.add(second);
        this.marks[0] = first;
        this.marks[1] = second;
        this.tokenCount = tokenCount;
    }

    public int getMarkCount() {
        return this.markSet.size();
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public String getSourceCodeSlice() {
        return this.code;
    }

    public void setSourceCodeSlice(String code) {
        this.code = code;
    }

    public Iterator<TokenEntry> iterator() {
        return this.markSet.iterator();
    }

    @Override
    public int compareTo(Match other) {
        int diff = other.getTokenCount() - this.getTokenCount();
        if (diff != 0) {
            return diff;
        }
        return other.getFirstMark().getIndex() - this.getFirstMark().getIndex();
    }

    public TokenEntry getFirstMark() {
        return this.marks[0];
    }

    public TokenEntry getSecondMark() {
        return this.marks[1];
    }

    public String toString() {
        return new StringBuffer().append("Match: ").append(PMD.EOL).append("tokenCount = ").append(this.tokenCount).append(PMD.EOL).append("marks = ").append(this.markSet.size()).toString();
    }

    public Set<TokenEntry> getMarkSet() {
        return this.markSet;
    }

    public MatchCode getMatchCode() {
        if (this.mc == null) {
            this.mc = new MatchCode(this.marks[0], this.marks[1]);
        }
        return this.mc;
    }

    public int getEndIndex() {
        return this.marks[1].getIndex() + this.getTokenCount() - 1;
    }

    public void setMarkSet(Set<TokenEntry> markSet) {
        this.markSet = markSet;
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((Match)x0);
    }

    public static class MatchCode {
        private int first;
        private int second;

        public MatchCode() {
        }

        public MatchCode(TokenEntry m1, TokenEntry m2) {
            this.first = m1.getIndex();
            this.second = m2.getIndex();
        }

        public int hashCode() {
            return this.first + 37 * this.second;
        }

        public boolean equals(Object other) {
            MatchCode mc = (MatchCode)other;
            return mc.first == this.first && mc.second == this.second;
        }

        public void setFirst(int first) {
            this.first = first;
        }

        public void setSecond(int second) {
            this.second = second;
        }
    }
}

