/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.CanSuppressWarnings;
import net.sourceforge.pmd.ast.SimpleNode;

public class RuleViolation
implements IRuleViolation {
    private Rule rule;
    private String description;
    private String filename;
    private String className;
    private String methodName;
    private String variableName;
    private String packageName;
    private int beginLine;
    private int endLine;
    private int beginColumn;
    private int endColumn;
    private boolean isSuppressed;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFormalParameter;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTTypeDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;

    public RuleViolation(Rule rule, RuleContext ctx, SimpleNode node) {
        this(rule, ctx, node, rule.getMessage());
    }

    public RuleViolation(Rule rule, RuleContext ctx, SimpleNode node, String specificMsg) {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        this.rule = rule;
        this.filename = ctx.getSourceCodeFilename();
        this.description = specificMsg;
        Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz4 == null) {
            clazz4 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        this.className = node.getFirstParentOfType(clazz4) == null ? "" : (node.getScope().getEnclosingClassScope().getClassName() == null ? "" : node.getScope().getEnclosingClassScope().getClassName());
        this.setVariableNameIfExists(node);
        Class<?> clazz5 = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
        if (clazz5 == null) {
            clazz5 = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
        }
        this.methodName = node.getFirstParentOfType(clazz5) == null ? "" : node.getScope().getEnclosingMethodScope().getName();
        this.packageName = node.getScope().getEnclosingSourceFileScope().getPackageName() == null ? "" : node.getScope().getEnclosingSourceFileScope().getPackageName();
        this.beginLine = node.getBeginLine();
        this.endLine = node.getEndLine();
        this.beginColumn = node.getBeginColumn();
        this.endColumn = node.getEndColumn();
        Class<?> clazz6 = class$net$sourceforge$pmd$ast$ASTTypeDeclaration;
        if (clazz6 == null) {
            clazz6 = class$net$sourceforge$pmd$ast$ASTTypeDeclaration = new ASTTypeDeclaration[0].getClass().getComponentType();
        }
        ArrayList parentTypes = new ArrayList(node.getParentsOfType(clazz6));
        if (node instanceof ASTTypeDeclaration) {
            parentTypes.add(node);
        }
        if ((clazz3 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration) == null) {
            clazz3 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceBodyDeclaration = new ASTClassOrInterfaceBodyDeclaration[0].getClass().getComponentType();
        }
        parentTypes.addAll(node.getParentsOfType(clazz3));
        if (node instanceof ASTClassOrInterfaceBodyDeclaration) {
            parentTypes.add(node);
        }
        if ((clazz2 = class$net$sourceforge$pmd$ast$ASTFormalParameter) == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTFormalParameter = new ASTFormalParameter[0].getClass().getComponentType();
        }
        parentTypes.addAll(node.getParentsOfType(clazz2));
        if (node instanceof ASTFormalParameter) {
            parentTypes.add(node);
        }
        if ((clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration) == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration = new ASTLocalVariableDeclaration[0].getClass().getComponentType();
        }
        parentTypes.addAll(node.getParentsOfType(clazz));
        if (node instanceof ASTLocalVariableDeclaration) {
            parentTypes.add(node);
        }
        Iterator i = parentTypes.iterator();
        while (i.hasNext()) {
            CanSuppressWarnings t = (CanSuppressWarnings)i.next();
            if (!t.hasSuppressWarningsAnnotationFor(this.getRule())) continue;
            this.isSuppressed = true;
        }
    }

    private void setVariableNameIfExists(SimpleNode node) {
        Class<?> clazz = node.getClass();
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
        }
        String string = this.variableName = clazz.equals(clazz2) ? ((ASTFieldDeclaration)node).getVariableName() : "";
        if (this.variableName == "") {
            Class<?> clazz3 = node.getClass();
            Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;
            if (clazz4 == null) {
                clazz4 = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration = new ASTLocalVariableDeclaration[0].getClass().getComponentType();
            }
            String string2 = this.variableName = clazz3.equals(clazz4) ? ((ASTLocalVariableDeclaration)node).getVariableName() : "";
        }
        if (this.variableName == "") {
            Class<?> clazz5 = node.getClass();
            Class<?> clazz6 = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
            if (clazz6 == null) {
                clazz6 = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
            }
            this.variableName = clazz5.equals(clazz6) ? node.getImage() : "";
        }
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean isSuppressed() {
        return this.isSuppressed;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String toString() {
        return this.getFilename() + ":" + this.getRule() + ":" + this.getDescription() + ":" + this.beginLine;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleViolationComparator
    implements Comparator<IRuleViolation> {
        @Override
        public int compare(IRuleViolation r1, IRuleViolation r2) {
            if (!r1.getFilename().equals(r2.getFilename())) {
                return r1.getFilename().compareTo(r2.getFilename());
            }
            if (r1.getBeginLine() != r2.getBeginLine()) {
                return r1.getBeginLine() - r2.getBeginLine();
            }
            if (r1.getDescription() != null && r2.getDescription() != null && !r1.getDescription().equals(r2.getDescription())) {
                return r1.getDescription().compareTo(r2.getDescription());
            }
            if (r1.getBeginLine() == r2.getBeginLine()) {
                return 1;
            }
            return r1.getBeginLine() - r2.getBeginLine();
        }

        @Override
        public int compare(Object x0, Object x1) {
            return this.compare((IRuleViolation)x0, (IRuleViolation)x1);
        }
    }
}

