/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleChain;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.ast.CompilationUnit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSets {
    private Collection<RuleSet> ruleSets = new ArrayList<RuleSet>();
    private RuleChain ruleChain = new RuleChain();

    public RuleSets() {
    }

    public RuleSets(RuleSet ruleSet) {
        this();
        this.addRuleSet(ruleSet);
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.ruleSets.add(ruleSet);
        this.ruleChain.add(ruleSet);
    }

    public RuleSet[] getAllRuleSets() {
        return this.ruleSets.toArray(new RuleSet[this.ruleSets.size()]);
    }

    public Iterator<RuleSet> getRuleSetsIterator() {
        return this.ruleSets.iterator();
    }

    public Set<Rule> getAllRules() {
        HashSet<Rule> result = new HashSet<Rule>();
        for (RuleSet r : this.ruleSets) {
            result.addAll(r.getRules());
        }
        return result;
    }

    public boolean applies(Language languageOfSource, Language languageOfRule) {
        return languageOfSource.equals(languageOfRule) || languageOfSource.equals(Language.JAVA) && null == languageOfRule;
    }

    public void apply(List<CompilationUnit> acuList, RuleContext ctx, Language language) {
        this.ruleChain.apply(acuList, ctx, language);
        for (RuleSet ruleSet : this.ruleSets) {
            if (!this.applies(language, ruleSet.getLanguage())) continue;
            ruleSet.apply(acuList, ctx);
        }
    }

    public boolean usesDFA(Language language) {
        for (RuleSet ruleSet : this.ruleSets) {
            if (!this.applies(language, ruleSet.getLanguage()) || !ruleSet.usesDFA()) continue;
            return true;
        }
        return false;
    }

    public Rule getRuleByName(String ruleName) {
        Rule rule = null;
        Iterator<RuleSet> i = this.ruleSets.iterator();
        while (i.hasNext() && rule == null) {
            RuleSet ruleSet = i.next();
            rule = ruleSet.getRuleByName(ruleName);
        }
        return rule;
    }

    public boolean usesTypeResolution(Language language) {
        for (RuleSet ruleSet : this.ruleSets) {
            if (!this.applies(language, ruleSet.getLanguage()) || !ruleSet.usesTypeResolution()) continue;
            return true;
        }
        return false;
    }
}

