/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.ExternalRuleID;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.util.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSetFactory {
    private int minPriority = 5;

    public void setMinimumPriority(int minPriority) {
        this.minPriority = minPriority;
    }

    public Iterator<RuleSet> getRegisteredRuleSets() throws RuleSetNotFoundException {
        try {
            Properties props = new Properties();
            props.load(ResourceLoader.loadResourceAsStream("rulesets/rulesets.properties"));
            String rulesetFilenames = props.getProperty("rulesets.filenames");
            return this.createRuleSets(rulesetFilenames).getRuleSetsIterator();
        }
        catch (IOException ioe) {
            throw new RuntimeException(new StringBuffer().append("Couldn't find rulesets.properties; please ensure that the rulesets directory is on the classpath.  Here's the current classpath: ").append(System.getProperty("java.class.path")).toString());
        }
    }

    public RuleSets createRuleSets(String ruleSetFileNames, ClassLoader classLoader) throws RuleSetNotFoundException {
        RuleSets ruleSets = new RuleSets();
        StringTokenizer st = new StringTokenizer(ruleSetFileNames, ",");
        while (st.hasMoreTokens()) {
            RuleSet ruleSet = this.createSingleRuleSet(st.nextToken().trim(), classLoader);
            ruleSets.addRuleSet(ruleSet);
        }
        return ruleSets;
    }

    public RuleSets createRuleSets(String ruleSetFileNames) throws RuleSetNotFoundException {
        return this.createRuleSets(ruleSetFileNames, this.getClass().getClassLoader());
    }

    public RuleSet createRuleSet(String name, ClassLoader classLoader) throws RuleSetNotFoundException {
        RuleSet[] allRuleSets;
        RuleSets ruleSets = this.createRuleSets(name, classLoader);
        RuleSet result = new RuleSet();
        for (RuleSet ruleSet : allRuleSets = ruleSets.getAllRuleSets()) {
            result.addRuleSet(ruleSet);
        }
        return result;
    }

    private RuleSet createSingleRuleSet(String ruleSetFileName, ClassLoader classLoader) throws RuleSetNotFoundException {
        return this.createRuleSet(this.tryToGetStreamTo(ruleSetFileName, classLoader), classLoader);
    }

    public RuleSet createSingleRuleSet(String ruleSetFileName) throws RuleSetNotFoundException {
        return this.createRuleSet(this.tryToGetStreamTo(ruleSetFileName, this.getClass().getClassLoader()));
    }

    public RuleSet createRuleSet(InputStream inputStream) {
        return this.createRuleSet(inputStream, this.getClass().getClassLoader());
    }

    public RuleSet createRuleSet(InputStream inputStream, ClassLoader classLoader) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(inputStream);
            Element root = doc.getDocumentElement();
            RuleSet ruleSet = new RuleSet();
            ruleSet.setName(root.getAttribute("name"));
            ruleSet.setLanguage(Language.getByName(root.getAttribute("language")));
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                if (node.getNodeName().equals("description")) {
                    ruleSet.setDescription(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if (!node.getNodeName().equals("rule")) continue;
                this.parseRuleNode(ruleSet, node, classLoader);
            }
            return ruleSet;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(cnfe.getMessage()).toString());
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(ie.getMessage()).toString());
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(iae.getMessage()).toString());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(pce.getMessage()).toString());
        }
        catch (RuleSetNotFoundException rsnfe) {
            rsnfe.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(rsnfe.getMessage()).toString());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(ioe.getMessage()).toString());
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(se.getMessage()).toString());
        }
    }

    private InputStream tryToGetStreamTo(String name, ClassLoader loader) throws RuleSetNotFoundException {
        InputStream in = ResourceLoader.loadResourceAsStream(name, loader);
        if (in == null) {
            throw new RuleSetNotFoundException(new StringBuffer().append("Can't find resource ").append(name).append(".  Make sure the resource is a valid file or URL or is on the CLASSPATH.  Here's the current classpath: ").append(System.getProperty("java.class.path")).toString());
        }
        return in;
    }

    private void parseRuleNode(RuleSet ruleSet, Node ruleNode, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, RuleSetNotFoundException {
        Element ruleElement = (Element)ruleNode;
        String ref = ruleElement.getAttribute("ref");
        if (ref.trim().length() == 0) {
            this.parseInternallyDefinedRuleNode(ruleSet, ruleNode, classLoader);
        } else {
            this.parseExternallyDefinedRuleNode(ruleSet, ruleNode);
        }
    }

    private void parseInternallyDefinedRuleNode(RuleSet ruleSet, Node ruleNode, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Element ruleElement = (Element)ruleNode;
        String attribute = ruleElement.getAttribute("class");
        Class<?> c = classLoader.loadClass(attribute);
        Rule rule = (Rule)c.newInstance();
        rule.setName(ruleElement.getAttribute("name"));
        rule.setMessage(ruleElement.getAttribute("message"));
        rule.setRuleSetName(ruleSet.getName());
        rule.setExternalInfoUrl(ruleElement.getAttribute("externalInfoUrl"));
        if (ruleElement.hasAttribute("dfa") && ruleElement.getAttribute("dfa").equals("true")) {
            rule.setUsesDFA();
        }
        if (ruleElement.hasAttribute("typeResolution") && ruleElement.getAttribute("typeResolution").equals("true")) {
            rule.setUsesTypeResolution();
        }
        for (int i = 0; i < ruleElement.getChildNodes().getLength(); ++i) {
            Node node = ruleElement.getChildNodes().item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("description")) {
                rule.setDescription(RuleSetFactory.parseTextNode(node));
                continue;
            }
            if (node.getNodeName().equals("example")) {
                rule.addExample(RuleSetFactory.parseTextNode(node));
                continue;
            }
            if (node.getNodeName().equals("priority")) {
                rule.setPriority(Integer.parseInt(RuleSetFactory.parseTextNode(node).trim()));
                continue;
            }
            if (!node.getNodeName().equals("properties")) continue;
            Properties p = new Properties();
            RuleSetFactory.parsePropertiesNode(p, node);
            for (String string : p.keySet()) {
                rule.addProperty(string, p.getProperty(string));
            }
        }
        if (rule.getPriority() <= this.minPriority) {
            ruleSet.addRule(rule);
        }
    }

    private void parseExternallyDefinedRuleNode(RuleSet ruleSet, Node ruleNode) throws RuleSetNotFoundException {
        Element ruleElement = (Element)ruleNode;
        String ref = ruleElement.getAttribute("ref");
        if (ref.endsWith("xml")) {
            this.parseRuleNodeWithExclude(ruleSet, ruleElement, ref);
        } else {
            this.parseRuleNodeWithSimpleReference(ruleSet, ruleNode, ref);
        }
    }

    private void parseRuleNodeWithSimpleReference(RuleSet ruleSet, Node ruleNode, String ref) throws RuleSetNotFoundException {
        RuleSetFactory rsf = new RuleSetFactory();
        ExternalRuleID externalRuleID = new ExternalRuleID(ref);
        RuleSet externalRuleSet = rsf.createRuleSet(ResourceLoader.loadResourceAsStream(externalRuleID.getFilename()));
        Rule externalRule = externalRuleSet.getRuleByName(externalRuleID.getRuleName());
        if (externalRule == null) {
            throw new IllegalArgumentException(new StringBuffer().append("Unable to find rule ").append(externalRuleID.getRuleName()).append("; perhaps the rule name is mispelled?").toString());
        }
        OverrideParser p = new OverrideParser((Element)ruleNode);
        p.overrideAsNecessary(externalRule);
        if (externalRule.getPriority() <= this.minPriority) {
            ruleSet.addRule(externalRule);
        }
    }

    private void parseRuleNodeWithExclude(RuleSet ruleSet, Element ruleElement, String ref) throws RuleSetNotFoundException {
        NodeList excludeNodes = ruleElement.getChildNodes();
        HashSet<String> excludes = new HashSet<String>();
        for (int i = 0; i < excludeNodes.getLength(); ++i) {
            if (excludeNodes.item(i).getNodeType() != 1 || !excludeNodes.item(i).getNodeName().equals("exclude")) continue;
            Element excludeElement = (Element)excludeNodes.item(i);
            excludes.add(excludeElement.getAttribute("name"));
        }
        RuleSetFactory rsf = new RuleSetFactory();
        RuleSet externalRuleSet = rsf.createRuleSet(ResourceLoader.loadResourceAsStream(ref));
        for (Rule rule : externalRuleSet.getRules()) {
            if (excludes.contains(rule.getName()) || rule.getPriority() > this.minPriority) continue;
            ruleSet.addRule(rule);
        }
    }

    private static String parseTextNode(Node node) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 4 && childNode.getNodeType() != 3) continue;
            buffer.append(childNode.getNodeValue());
        }
        return buffer.toString();
    }

    private static void parsePropertiesNode(Properties p, Node propertiesNode) {
        for (int i = 0; i < propertiesNode.getChildNodes().getLength(); ++i) {
            Node node = propertiesNode.getChildNodes().item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("property")) continue;
            RuleSetFactory.parsePropertyNode(p, node);
        }
    }

    private static void parsePropertyNode(Properties p, Node propertyNode) {
        Element propertyElement = (Element)propertyNode;
        String name = propertyElement.getAttribute("name");
        String value = propertyElement.getAttribute("value");
        if (value.trim().length() == 0) {
            for (int i = 0; i < propertyNode.getChildNodes().getLength(); ++i) {
                Node node = propertyNode.getChildNodes().item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("value")) continue;
                value = RuleSetFactory.parseTextNode(node);
            }
        }
        if (propertyElement.hasAttribute("pluginname")) {
            p.setProperty("pluginname", propertyElement.getAttributeNode("pluginname").getNodeValue());
        }
        p.setProperty(name, value);
    }

    private static class OverrideParser {
        private Element ruleElement;

        public OverrideParser(Element ruleElement) {
            this.ruleElement = ruleElement;
        }

        public void overrideAsNecessary(Rule rule) {
            if (this.ruleElement.hasAttribute("name")) {
                rule.setName(this.ruleElement.getAttribute("name"));
            }
            if (this.ruleElement.hasAttribute("message")) {
                rule.setMessage(this.ruleElement.getAttribute("message"));
            }
            if (this.ruleElement.hasAttribute("externalInfoUrl")) {
                rule.setExternalInfoUrl(this.ruleElement.getAttribute("externalInfoUrl"));
            }
            for (int i = 0; i < this.ruleElement.getChildNodes().getLength(); ++i) {
                Node node = this.ruleElement.getChildNodes().item(i);
                if (node.getNodeType() != 1) continue;
                if (node.getNodeName().equals("description")) {
                    rule.setDescription(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if (node.getNodeName().equals("example")) {
                    rule.addExample(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if (node.getNodeName().equals("priority")) {
                    rule.setPriority(Integer.parseInt(RuleSetFactory.parseTextNode(node)));
                    continue;
                }
                if (!node.getNodeName().equals("properties")) continue;
                Properties p = new Properties();
                RuleSetFactory.parsePropertiesNode(p, node);
                rule.addProperties(p);
            }
        }
    }
}

