/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.HttpMsg;
import org.eclipse.equinox.http.servlet.HttpSessionContextImpl;

public class HttpSessionImpl
implements HttpSession {
    protected Http http;
    protected String sessionId;
    protected Hashtable values;
    protected long creationTime;
    protected long lastAccess;
    protected boolean isValid;
    protected boolean canExpire;
    protected Cookie cookie;
    protected long maxInactive;
    protected static final String sessionCookieName = "org.eclipse.equinox.http.session";

    protected HttpSessionImpl(Http http) {
        this.http = http;
        this.lastAccess = -1L;
        this.maxInactive = -1L;
        this.canExpire = false;
        this.isValid = true;
        this.sessionId = String.valueOf(this.hashCode());
        this.values = new Hashtable();
        this.creationTime = System.currentTimeMillis();
        this.cookie = new Cookie(sessionCookieName, this.sessionId);
        http.addSession(this);
    }

    protected Cookie getCookie() {
        return this.cookie;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        return this.lastAccess;
    }

    public int getMaxInactiveInterval() {
        this.checkValid();
        if (this.canExpire) {
            return (int)(this.maxInactive / 1000L);
        }
        return -1;
    }

    public void setMaxInactiveInterval(int interval) {
        if (this.isValid) {
            if (interval == -1) {
                this.maxInactive = -1L;
                this.canExpire = false;
            } else {
                if (interval < 0) {
                    throw new IllegalArgumentException("negative value");
                }
                this.maxInactive = (long)interval * 1000L;
                this.canExpire = true;
            }
        }
    }

    public HttpSessionContext getSessionContext() {
        return new HttpSessionContextImpl();
    }

    public Object getValue(String name) {
        this.checkValid();
        return this.values.get(name);
    }

    public String[] getValueNames() {
        this.checkValid();
        return this.getValueNames0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getValueNames0() {
        Hashtable hashtable = this.values;
        synchronized (hashtable) {
            int size = this.values.size();
            String[] names = new String[size];
            if (size > 0) {
                int i = 0;
                Enumeration valueEnumeration = this.values.keys();
                while (valueEnumeration.hasMoreElements()) {
                    names[i] = (String)valueEnumeration.nextElement();
                    ++i;
                }
            }
            return names;
        }
    }

    public synchronized void invalidate() {
        if (this.isValid) {
            this.http.removeSession(this);
            String[] names = this.getValueNames0();
            int size = names.length;
            int i = 0;
            while (i < size) {
                String name = names[i];
                Object oldValue = this.values.remove(name);
                this.unbound(name, oldValue);
                ++i;
            }
            this.isValid = false;
            this.values = null;
            this.canExpire = false;
        }
    }

    public boolean isNew() {
        this.checkValid();
        return this.lastAccess == -1L;
    }

    public void putValue(String name, Object value) {
        this.checkValid();
        Object oldValue = this.values.put(name, value);
        this.unbound(name, oldValue);
        this.bound(name, value);
    }

    private void bound(String name, Object value) {
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent e = new HttpSessionBindingEvent((HttpSession)this, name);
            try {
                ((HttpSessionBindingListener)value).valueBound(e);
            }
            catch (Throwable throwable) {}
        }
    }

    public void removeValue(String name) {
        this.checkValid();
        Object oldValue = this.values.remove(name);
        this.unbound(name, oldValue);
    }

    private void unbound(String name, Object value) {
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent e = new HttpSessionBindingEvent((HttpSession)this, name);
            try {
                ((HttpSessionBindingListener)value).valueUnbound(e);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean isValid(boolean access) {
        if (this.canExpire) {
            long compareTime;
            long currentTime = System.currentTimeMillis();
            long l = compareTime = this.lastAccess == -1L ? this.creationTime : this.lastAccess;
            if (currentTime - compareTime > this.maxInactive) {
                this.invalidate();
            }
        }
        if (access && this.isValid) {
            this.lastAccess = System.currentTimeMillis();
        }
        return this.isValid;
    }

    private void checkValid() {
        if (this.canExpire) {
            long compareTime;
            long currentTime = System.currentTimeMillis();
            long l = compareTime = this.lastAccess == -1L ? this.creationTime : this.lastAccess;
            if (currentTime - compareTime > this.maxInactive) {
                this.invalidate();
            }
        }
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession has been invalidated");
        }
    }

    public Object getAttribute(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public Enumeration getAttributeNames() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public ServletContext getServletContext() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void removeAttribute(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }

    public void setAttribute(String name, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
    }
}

