/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTTryStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.symboltable.STBBaseTst;

public class VariableNameDeclarationTest
extends STBBaseTst {
    public static final String TEST1 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  int bar = 42;" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST2 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  try {} catch(Exception e) {}" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST3 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  int[] x;" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST4 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  String x;" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST5 = "public class Foo {" + PMD.EOL + " void foo(String x) {}" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$symboltable$VariableNameDeclarationTest;

    @org.junit.Test
    public void testConstructor() {
        this.parseCode(TEST1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        Scope s = ((ASTVariableDeclaratorId)nodes.get(0)).getScope();
        VariableNameDeclaration decl = (VariableNameDeclaration)s.getVariableDeclarations().keySet().iterator().next();
        Assert.assertEquals((Object)"bar", (Object)decl.getImage());
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)decl.getNode().getBeginLine()));
    }

    @org.junit.Test
    public void testExceptionBlkParam() {
        ASTVariableDeclaratorId id = new ASTVariableDeclaratorId(3);
        id.testingOnly__setBeginLine(10);
        id.setImage("foo");
        ASTFormalParameter param = new ASTFormalParameter(2);
        id.jjtSetParent((Node)param);
        param.jjtSetParent((Node)new ASTTryStatement(1));
        VariableNameDeclaration decl = new VariableNameDeclaration(id);
        Assert.assertTrue((boolean)decl.isExceptionBlockParameter());
    }

    @org.junit.Test
    public void testIsArray() {
        this.parseCode(TEST3);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        VariableNameDeclaration decl = (VariableNameDeclaration)((ASTVariableDeclaratorId)this.acu.findChildrenOfType((Class)clazz).get(0)).getScope().getVariableDeclarations().keySet().iterator().next();
        Assert.assertTrue((boolean)decl.isArray());
    }

    @org.junit.Test
    public void testPrimitiveType() {
        this.parseCode(TEST1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        VariableNameDeclaration decl = (VariableNameDeclaration)((ASTVariableDeclaratorId)this.acu.findChildrenOfType((Class)clazz).get(0)).getScope().getVariableDeclarations().keySet().iterator().next();
        Assert.assertTrue((boolean)decl.isPrimitiveType());
    }

    @org.junit.Test
    public void testArrayIsReferenceType() {
        this.parseCode(TEST3);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        VariableNameDeclaration decl = (VariableNameDeclaration)((ASTVariableDeclaratorId)this.acu.findChildrenOfType((Class)clazz).get(0)).getScope().getVariableDeclarations().keySet().iterator().next();
        Assert.assertTrue((boolean)decl.isReferenceType());
    }

    @org.junit.Test
    public void testPrimitiveTypeImage() {
        this.parseCode(TEST3);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        VariableNameDeclaration decl = (VariableNameDeclaration)((ASTVariableDeclaratorId)this.acu.findChildrenOfType((Class)clazz).get(0)).getScope().getVariableDeclarations().keySet().iterator().next();
        Assert.assertEquals((Object)"int", (Object)decl.getTypeImage());
    }

    @org.junit.Test
    public void testRefTypeImage() {
        this.parseCode(TEST4);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        VariableNameDeclaration decl = (VariableNameDeclaration)((ASTVariableDeclaratorId)this.acu.findChildrenOfType((Class)clazz).get(0)).getScope().getVariableDeclarations().keySet().iterator().next();
        Assert.assertEquals((Object)"String", (Object)decl.getTypeImage());
    }

    @org.junit.Test
    public void testParamTypeImage() {
        this.parseCode(TEST5);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        VariableNameDeclaration decl = (VariableNameDeclaration)((ASTVariableDeclaratorId)this.acu.findChildrenOfType((Class)clazz).get(0)).getScope().getVariableDeclarations().keySet().iterator().next();
        Assert.assertEquals((Object)"String", (Object)decl.getTypeImage());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$symboltable$VariableNameDeclarationTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$symboltable$VariableNameDeclarationTest = new VariableNameDeclarationTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

