/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import java.util.List;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.symboltable.MethodScope;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.symboltable.STBBaseTst;

public class MethodScopeTest
extends STBBaseTst {
    public static final String TEST1 = "public class Foo {" + PMD.EOL + " void foo(int bar) {" + PMD.EOL + "  bar = 2;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$symboltable$MethodScopeTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;

    @org.junit.Test
    public void testMethodParameterOccurrenceRecorded() {
        this.parseCode(TEST1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
        }
        Map m = ((ASTMethodDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0)).getScope().getVariableDeclarations();
        VariableNameDeclaration vnd = (VariableNameDeclaration)m.keySet().iterator().next();
        Assert.assertEquals((Object)"bar", (Object)vnd.getImage());
        List occs = (List)m.get(vnd);
        NameOccurrence occ = (NameOccurrence)occs.get(0);
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)occ.getLocation().getBeginLine()));
    }

    @org.junit.Test
    public void testMethodName() {
        this.parseCode(TEST1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
        }
        ASTMethodDeclaration meth = (ASTMethodDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        MethodScope ms = (MethodScope)meth.getScope();
        Assert.assertEquals((Object)ms.getName(), (Object)"foo");
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$symboltable$MethodScopeTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$symboltable$MethodScopeTest = new MethodScopeTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

