/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.symboltable;

import java.util.List;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.LocalScope;
import net.sourceforge.pmd.symboltable.MethodScope;
import net.sourceforge.pmd.symboltable.NameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.junit.Test;
import test.net.sourceforge.pmd.symboltable.STBBaseTst;

public class LocalScopeTest
extends STBBaseTst {
    public static final String TEST1 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  Bar b = new Bar();" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST2 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  Bar b = new Bar();" + PMD.EOL + "  b.buz = 2;" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST3 = "public class Foo {" + PMD.EOL + " void foo() {" + PMD.EOL + "  int x = 2;" + PMD.EOL + "  x++;" + PMD.EOL + " }" + PMD.EOL + "}";
    public static final String TEST4 = "public class Foo {" + PMD.EOL + " void foo(String x, String z) { int y; }" + PMD.EOL + "}";
    public static final String TEST5 = "public class Foo {" + PMD.EOL + " void foo(String x);" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFormalParameter;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$symboltable$LocalScopeTest;

    @Test
    public void testNameWithThisOrSuperIsNotFlaggedAsUnused() {
        LocalScope scope = new LocalScope();
        ASTName name = new ASTName(1);
        name.setImage("foo");
        ASTPrimaryPrefix prefix = new ASTPrimaryPrefix(2);
        prefix.setUsesThisModifier();
        name.jjtAddChild((Node)prefix, 1);
        NameOccurrence occ = new NameOccurrence((SimpleNode)name, "foo");
        scope.addVariableNameOccurrence(occ);
        Assert.assertFalse((boolean)scope.getVariableDeclarations().keySet().iterator().hasNext());
    }

    @Test
    public void testNameWithSuperIsNotFlaggedAsUnused() {
        LocalScope scope = new LocalScope();
        ASTName name = new ASTName(1);
        name.setImage("foo");
        ASTPrimaryPrefix prefix = new ASTPrimaryPrefix(2);
        prefix.setUsesSuperModifier();
        name.jjtAddChild((Node)prefix, 1);
        NameOccurrence occ = new NameOccurrence((SimpleNode)name, "foo");
        scope.addVariableNameOccurrence(occ);
        Assert.assertFalse((boolean)scope.getVariableDeclarations().keySet().iterator().hasNext());
    }

    @Test
    public void testLocalVariableDeclarationFound() {
        this.parseCode(TEST1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        ASTVariableDeclaratorId node = (ASTVariableDeclaratorId)nodes.get(0);
        Map vars = node.getScope().getVariableDeclarations();
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)vars.size()));
        NameDeclaration decl = (NameDeclaration)vars.keySet().iterator().next();
        Assert.assertEquals((Object)"b", (Object)decl.getImage());
    }

    @Test
    public void testQualifiedNameOccurrence() {
        this.parseCode(TEST2);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        ASTVariableDeclaratorId node = (ASTVariableDeclaratorId)nodes.get(0);
        Map vars = node.getScope().getVariableDeclarations();
        NameDeclaration decl = (NameDeclaration)vars.keySet().iterator().next();
        NameOccurrence occ = (NameOccurrence)((List)vars.get(decl)).get(0);
        Assert.assertEquals((Object)"b", (Object)occ.getImage());
    }

    @Test
    public void testPostfixUsageIsRecorded() {
        this.parseCode(TEST3);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        ASTVariableDeclaratorId node = (ASTVariableDeclaratorId)nodes.get(0);
        Map vars = node.getScope().getVariableDeclarations();
        NameDeclaration decl = (NameDeclaration)vars.keySet().iterator().next();
        List usages = (List)vars.get(decl);
        NameOccurrence occ = (NameOccurrence)usages.get(0);
        Assert.assertEquals((Object)Integer_.valueOf((int)4), (Object)Integer_.valueOf((int)occ.getLocation().getBeginLine()));
    }

    @Test
    public void testLocalVariableTypesAreRecorded() {
        this.parseCode(TEST1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclaratorId = new ASTVariableDeclaratorId[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        Map vars = ((ASTVariableDeclaratorId)nodes.get(0)).getScope().getVariableDeclarations();
        VariableNameDeclaration decl = (VariableNameDeclaration)vars.keySet().iterator().next();
        Assert.assertEquals((Object)"Bar", (Object)decl.getTypeImage());
    }

    @Test
    public void testMethodArgumentTypesAreRecorded() {
        this.parseCode(TEST5);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTFormalParameter;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTFormalParameter = new ASTFormalParameter[0].getClass().getComponentType();
        }
        List nodes = this.acu.findChildrenOfType((Class)clazz);
        Map vars = ((ASTFormalParameter)nodes.get(0)).getScope().getVariableDeclarations();
        VariableNameDeclaration decl = (VariableNameDeclaration)vars.keySet().iterator().next();
        Assert.assertEquals((Object)"String", (Object)decl.getTypeImage());
    }

    @Test
    public void testgetEnclosingMethodScope() {
        this.parseCode(TEST4);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration = new ASTLocalVariableDeclaration[0].getClass().getComponentType();
        }
        ASTLocalVariableDeclaration node = (ASTLocalVariableDeclaration)this.acu.findChildrenOfType((Class)clazz).get(0);
        LocalScope scope = (LocalScope)node.getScope();
        MethodScope ms = scope.getEnclosingMethodScope();
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)ms.getVariableDeclarations().size()));
    }

    public static junit.framework.Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$symboltable$LocalScopeTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$symboltable$LocalScopeTest = new LocalScopeTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

