/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules.strings;

import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.rules.strings.AvoidDuplicateLiteralsRule;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.testframework.SimpleAggregatorTst;

public class AvoidDuplicateLiteralsRuleTest
extends SimpleAggregatorTst {
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$rules$strings$AvoidDuplicateLiteralsRuleTest;

    @org.junit.Test
    public void testAll() {
        Rule rule = this.findRule("strings", "AvoidDuplicateLiterals");
        rule.addProperty("threshold", "2");
        this.runTests(rule);
    }

    @org.junit.Test
    public void testStringParserEmptyString() {
        AvoidDuplicateLiteralsRule.ExceptionParser p = new AvoidDuplicateLiteralsRule.ExceptionParser(',');
        Set res = p.parse("");
        Assert.assertTrue((boolean)res.isEmpty());
    }

    @org.junit.Test
    public void testStringParserSimple() {
        AvoidDuplicateLiteralsRule.ExceptionParser p = new AvoidDuplicateLiteralsRule.ExceptionParser(',');
        Set res = p.parse("a,b,c");
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)res.size()));
        Assert.assertTrue((boolean)res.contains("a"));
        Assert.assertTrue((boolean)res.contains("b"));
        Assert.assertTrue((boolean)res.contains("c"));
    }

    @org.junit.Test
    public void testStringParserEscapedChar() {
        AvoidDuplicateLiteralsRule.ExceptionParser p = new AvoidDuplicateLiteralsRule.ExceptionParser(',');
        Set res = p.parse("a,b,\\,");
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)res.size()));
        Assert.assertTrue((boolean)res.contains("a"));
        Assert.assertTrue((boolean)res.contains("b"));
        Assert.assertTrue((boolean)res.contains(","));
    }

    @org.junit.Test
    public void testStringParserEscapedEscapedChar() {
        AvoidDuplicateLiteralsRule.ExceptionParser p = new AvoidDuplicateLiteralsRule.ExceptionParser(',');
        Set res = p.parse("a,b,\\\\");
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)res.size()));
        Assert.assertTrue((boolean)res.contains("a"));
        Assert.assertTrue((boolean)res.contains("b"));
        Assert.assertTrue((boolean)res.contains("\\"));
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$rules$strings$AvoidDuplicateLiteralsRuleTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$rules$strings$AvoidDuplicateLiteralsRuleTest = new AvoidDuplicateLiteralsRuleTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

