/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import junit.framework.JUnit4TestAdapter;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.util.ResourceLoader;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import test.net.sourceforge.pmd.testframework.SimpleAggregatorTst;
import test.net.sourceforge.pmd.testframework.TestDescriptor;

@RunWith(value=Parameterized.class)
public class DynamicRuleTest
extends SimpleAggregatorTst {
    private Rule rule;
    private String strRuleset;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$rules$DynamicRuleTest;

    public DynamicRuleTest(String strRuleset, Rule rule) {
        this.rule = rule;
        this.strRuleset = strRuleset;
    }

    @Parameterized.Parameters
    public static Collection data() throws IOException, RuleSetNotFoundException {
        ArrayList<Object[]> allRules = new ArrayList<Object[]>();
        RuleSetFactory rsf = new RuleSetFactory();
        String rulesetFilenames = null;
        Properties props = new Properties();
        props.load(ResourceLoader.loadResourceAsStream((String)"rulesets/rulesets.properties"));
        rulesetFilenames = props.getProperty("rulesets.testnames");
        StringTokenizer st = new StringTokenizer(rulesetFilenames, ",");
        while (st.hasMoreTokens()) {
            String strRule = st.nextToken();
            String strCleanRule = DynamicRuleTest.cleanRulesetName(strRule);
            RuleSets ruleSets = rsf.createRuleSets(strRule);
            Iterator iter = ruleSets.getRuleSetsIterator();
            while (iter.hasNext()) {
                RuleSet ruleSet = (RuleSet)iter.next();
                Iterator i$ = ruleSet.getRules().iterator();
                while (i$.hasNext()) {
                    Rule rule = (Rule)i$.next();
                    allRules.add(new Object[]{strCleanRule, rule});
                }
            }
        }
        return allRules;
    }

    private static String cleanRulesetName(String strRule) {
        return strRule.substring(strRule.indexOf(47) + 1, strRule.indexOf(46)).replaceAll("-", "") + "/xml/";
    }

    @Ignore
    @Test
    public void testAll() {
        TestDescriptor[] td = this.extractTestsFromXml(this.rule, this.getCleanRuleName(this.rule), this.strRuleset);
        this.runTests(td);
    }

    public static junit.framework.Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$rules$DynamicRuleTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$rules$DynamicRuleTest = new DynamicRuleTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

