/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.renderers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.renderers.PapariTextRenderer;
import test.net.sourceforge.pmd.renderers.AbstractRendererTst;

public class PapariTextRendererTest
extends AbstractRendererTst {
    private static String naString = "n/a";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$renderers$PapariTextRendererTest;

    public AbstractRenderer getRenderer() {
        return new PapariTextRenderer(){

            protected Reader getReader(String sourceFile) throws FileNotFoundException {
                return new StringReader("public class Foo {}");
            }
        };
    }

    public String getExpected() {
        return "* file: n/a" + PMD.EOL + "    src:  " + naString + ":1:1" + PMD.EOL + "    rule: Foo" + PMD.EOL + "    msg:  msg" + PMD.EOL + "    code: public class Foo {}" + PMD.EOL + PMD.EOL + PMD.EOL + PMD.EOL + "Summary:" + PMD.EOL + PMD.EOL + " : 1" + PMD.EOL + "* warnings: 1" + PMD.EOL;
    }

    public String getExpectedEmpty() {
        return PMD.EOL + PMD.EOL + "Summary:" + PMD.EOL + PMD.EOL + "* warnings: 0" + PMD.EOL;
    }

    public String getExpectedMultiple() {
        return "* file: n/a" + PMD.EOL + "    src:  " + naString + ":1:1" + PMD.EOL + "    rule: Foo" + PMD.EOL + "    msg:  msg" + PMD.EOL + "    code: public class Foo {}" + PMD.EOL + PMD.EOL + "    src:  " + naString + ":1:1" + PMD.EOL + "    rule: Foo" + PMD.EOL + "    msg:  msg" + PMD.EOL + "    code: public class Foo {}" + PMD.EOL + PMD.EOL + PMD.EOL + PMD.EOL + "Summary:" + PMD.EOL + PMD.EOL + " : 2" + PMD.EOL + "* warnings: 2" + PMD.EOL;
    }

    public String getExpectedError(Report.ProcessingError error) {
        return PMD.EOL + PMD.EOL + "Summary:" + PMD.EOL + PMD.EOL + "    err:  Error" + PMD.EOL + PMD.EOL + "* errors:   0" + PMD.EOL + "* warnings: 0" + PMD.EOL;
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$renderers$PapariTextRendererTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$renderers$PapariTextRendererTest = new PapariTextRendererTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }

    static {
        naString = naString.substring(naString.lastIndexOf(File.separator) + 1);
    }
}

