/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.renderers;

import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import org.junit.Assert;
import org.junit.Test;
import test.net.sourceforge.pmd.testframework.RuleTst;

public abstract class AbstractRendererTst
extends RuleTst {
    private static final String TEST1 = "public class Foo {}" + PMD.EOL;

    public abstract AbstractRenderer getRenderer();

    public abstract String getExpected();

    public abstract String getExpectedEmpty();

    public abstract String getExpectedMultiple();

    public String getExpectedError(Report.ProcessingError error) {
        return "";
    }

    @Test(expected=NullPointerException.class)
    public void testNullPassedIn() {
        this.getRenderer().render(null);
    }

    @Test
    public void testRenderer() throws Throwable {
        Report rep = new Report();
        this.runTestFromString(TEST1, (Rule)new FooRule(), rep);
        String actual = this.getRenderer().render(rep);
        Assert.assertEquals((Object)this.getExpected(), (Object)actual);
    }

    @Test
    public void testRendererEmpty() throws Throwable {
        Report rep = new Report();
        String actual = this.getRenderer().render(rep);
        Assert.assertEquals((Object)this.getExpectedEmpty(), (Object)actual);
    }

    @Test
    public void testRendererMultiple() throws Throwable {
        Report rep = new Report();
        this.runTestFromString(TEST1, (Rule)new FooRule2(), rep);
        String actual = this.getRenderer().render(rep);
        Assert.assertEquals((Object)this.getExpectedMultiple(), (Object)actual);
    }

    @Test
    public void testError() throws Throwable {
        Report rep = new Report();
        Report.ProcessingError err = new Report.ProcessingError("Error", "file");
        rep.addError(err);
        String actual = this.getRenderer().render(rep);
        Assert.assertEquals((Object)this.getExpectedError(err), (Object)actual);
    }

    private static class FooRule2
    extends FooRule {
        private FooRule2() {
        }

        public Object visit(ASTClassOrInterfaceDeclaration c, Object ctx) {
            if (c.getImage().equals("Foo")) {
                this.addViolation(ctx, (SimpleNode)c);
                this.addViolation(ctx, (SimpleNode)c.jjtGetChild(0));
            }
            return ctx;
        }
    }

    private static class FooRule
    extends AbstractRule {
        private FooRule() {
        }

        public Object visit(ASTClassOrInterfaceDeclaration c, Object ctx) {
            if (c.getImage().equals("Foo")) {
                this.addViolation(ctx, (SimpleNode)c);
            }
            return ctx;
        }

        public String getMessage() {
            return "msg";
        }

        public String getName() {
            return "Foo";
        }

        public String getRuleSetName() {
            return "RuleSet";
        }

        public String getDescription() {
            return "desc";
        }
    }
}

