/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.properties;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.Assert;

public abstract class AbstractPropertyDescriptorTester {
    private static final int maxCardinality = 10;
    public static final String punctuationChars = "!@#$%^&*()_-+=[]{}\\|;:'\",.<>/?`~";
    public static final String whitespaceChars = " \t\n";
    public static final String digitChars = "0123456789";
    public static final String alphaChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmniopqrstuvwxyz";
    public static final String alphaNumericChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmniopqrstuvwxyz";
    public static final String allChars = "!@#$%^&*()_-+=[]{}\\|;:'\",.<>/?`~ \t\n0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmniopqrstuvwxyz";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$properties$AbstractPropertyDescriptorTester;

    protected abstract Object createValue(int var1);

    protected abstract PropertyDescriptor createProperty(int var1);

    @org.junit.Test
    public void testAsDelimitedString() {
        Object testValue = this.createValue(10);
        PropertyDescriptor pmdProp = this.createProperty(10);
        String storeValue = pmdProp.asDelimitedString(testValue);
        Object returnedValue = pmdProp.valueFrom(storeValue);
        Assert.assertTrue((boolean)CollectionUtil.areEqual((Object)returnedValue, (Object)testValue));
    }

    @org.junit.Test
    public void testValueFrom() {
        Object testValue = this.createValue(1);
        PropertyDescriptor pmdProp = this.createProperty(1);
        String storeValue = pmdProp.asDelimitedString(testValue);
        Object returnedValue = pmdProp.valueFrom(storeValue);
        Assert.assertTrue((boolean)CollectionUtil.areEqual((Object)returnedValue, (Object)testValue));
    }

    @org.junit.Test
    public void testErrorFor() {
        Object testValue = this.createValue(1);
        PropertyDescriptor pmdProp = this.createProperty(1);
        String errorMsg = pmdProp.errorFor(testValue);
        Assert.assertTrue((errorMsg == null ? 1 : 0) != 0);
        testValue = this.createValue(10);
        pmdProp = this.createProperty(10);
        errorMsg = pmdProp.errorFor(testValue);
        Assert.assertTrue((errorMsg == null ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testType() {
        PropertyDescriptor pmdProp = this.createProperty(1);
        Assert.assertTrue((pmdProp.type() != null ? 1 : 0) != 0);
    }

    public static int randomInt() {
        int randomVal = (int)(Math.random() * 100.0 + 1.0);
        return randomVal + (int)(Math.random() * 100000.0);
    }

    public static int randomInt(int min, int max) {
        if (max < min) {
            max = min;
        }
        int range = Math.abs(max - min);
        int x = (int)((double)range * Math.random() + 0.5);
        return x + min;
    }

    public static char randomChar(char[] characters) {
        return characters[AbstractPropertyDescriptorTester.randomInt(0, characters.length - 1)];
    }

    public static Object randomChoice(Object[] items) {
        return items[AbstractPropertyDescriptorTester.randomInt(0, items.length - 1)];
    }

    protected static final char[] filter(char[] chars, char removeChar) {
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != removeChar) continue;
            ++count;
        }
        char[] results = new char[chars.length - count];
        int index = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == removeChar) continue;
            results[index++] = chars[i];
        }
        return results;
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$properties$AbstractPropertyDescriptorTester;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$properties$AbstractPropertyDescriptorTester = new AbstractPropertyDescriptorTester[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

