/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.jsp.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.jsp.ast.ASTAttribute;
import net.sourceforge.pmd.jsp.ast.ASTAttributeValue;
import net.sourceforge.pmd.jsp.ast.ASTCData;
import net.sourceforge.pmd.jsp.ast.ASTCommentTag;
import net.sourceforge.pmd.jsp.ast.ASTDoctypeDeclaration;
import net.sourceforge.pmd.jsp.ast.ASTDoctypeExternalId;
import net.sourceforge.pmd.jsp.ast.ASTElement;
import net.sourceforge.retroweaver.runtime.java.lang.Boolean_;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.jsp.ast.AbstractJspNodesTst;

public class JspDocStyleTest
extends AbstractJspNodesTst {
    private static final String TEST_SIMPLEST_HTML = "<html/>";
    private static final String TEST_ELEMENT_AND_NAMESPACE = "<h:html MyNsPrefix:MyAttr='MyValue'/>";
    private static final String TEST_CDATA = "<html><![CDATA[ some <cdata> ]] ]> ]]></html>";
    private static final String TEST_DOCTYPE = "<?xml version=\"1.0\" standalone='yes'?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<greeting>Hello, world!</greeting>";
    private static final String TEST_COMMENT = "<html><!-- comment --></html>";
    private static final String TEST_ATTRIBUTE_VALUE_CONTAINING_HASH = "<tag:if something=\"#yes#\" foo=\"CREATE\">  <a href=\"#\">foo</a> </tag:if>";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTDoctypeDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTElement;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$jsp$ast$JspDocStyleTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTCommentTag;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTAttributeValue;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTCData;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTDoctypeExternalId;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$jsp$ast$ASTAttribute;

    @org.junit.Test
    public void testSimplestJsp() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTElement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTElement = new ASTElement[0].getClass().getComponentType();
        }
        this.assertNumberOfNodes(clazz, TEST_SIMPLEST_HTML, 1);
    }

    @org.junit.Test
    public void testElementAttributeAndNamespace() throws Throwable {
        Set nodes = this.getNodes(null, TEST_ELEMENT_AND_NAMESPACE);
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTElement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTElement = new ASTElement[0].getClass().getComponentType();
        }
        Set elementNodes = this.getNodesOfType(clazz, nodes);
        Assert.assertEquals((String)"One element node expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)elementNodes.size()));
        ASTElement element = (ASTElement)elementNodes.iterator().next();
        Assert.assertEquals((String)"Correct name expected!", (Object)"h:html", (Object)element.getName());
        Assert.assertEquals((String)"Has namespace prefix!", (Object)Boolean_.valueOf((boolean)true), (Object)Boolean_.valueOf((boolean)element.isHasNamespacePrefix()));
        Assert.assertEquals((String)"Element is empty!", (Object)Boolean_.valueOf((boolean)true), (Object)Boolean_.valueOf((boolean)element.isEmpty()));
        Assert.assertEquals((String)"Correct namespace prefix of element expected!", (Object)"h", (Object)element.getNamespacePrefix());
        Assert.assertEquals((String)"Correct local name of element expected!", (Object)"html", (Object)element.getLocalName());
        Class<?> clazz2 = class$net$sourceforge$pmd$jsp$ast$ASTAttribute;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$jsp$ast$ASTAttribute = new ASTAttribute[0].getClass().getComponentType();
        }
        Set attributeNodes = this.getNodesOfType(clazz2, nodes);
        Assert.assertEquals((String)"One attribute node expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)attributeNodes.size()));
        ASTAttribute attribute = (ASTAttribute)attributeNodes.iterator().next();
        Assert.assertEquals((String)"Correct name expected!", (Object)"MyNsPrefix:MyAttr", (Object)attribute.getName());
        Assert.assertEquals((String)"Has namespace prefix!", (Object)Boolean_.valueOf((boolean)true), (Object)Boolean_.valueOf((boolean)attribute.isHasNamespacePrefix()));
        Assert.assertEquals((String)"Correct namespace prefix of element expected!", (Object)"MyNsPrefix", (Object)attribute.getNamespacePrefix());
        Assert.assertEquals((String)"Correct local name of element expected!", (Object)"MyAttr", (Object)attribute.getLocalName());
    }

    @org.junit.Test
    public void testAttributeValueContainingHash() {
        Set nodes = this.getNodes(null, TEST_ATTRIBUTE_VALUE_CONTAINING_HASH);
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTAttribute;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTAttribute = new ASTAttribute[0].getClass().getComponentType();
        }
        Set attributes = this.getNodesOfType(clazz, nodes);
        Assert.assertEquals((String)"Three attributes expected!", (Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)attributes.size()));
        ArrayList attrsList = new ArrayList(attributes);
        Collections.sort(attrsList, new Comparator<ASTAttribute>(){

            @Override
            public int compare(ASTAttribute arg0, ASTAttribute arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }

            @Override
            public int compare(Object x0, Object x1) {
                return this.compare((ASTAttribute)x0, (ASTAttribute)x1);
            }
        });
        ASTAttribute attr = (ASTAttribute)attrsList.get(0);
        Assert.assertEquals((String)"Correct attribute name expected!", (Object)"foo", (Object)attr.getName());
        Class<?> clazz2 = class$net$sourceforge$pmd$jsp$ast$ASTAttributeValue;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$jsp$ast$ASTAttributeValue = new ASTAttributeValue[0].getClass().getComponentType();
        }
        Assert.assertEquals((String)"Correct attribute value expected!", (Object)"CREATE", (Object)((ASTAttributeValue)attr.getFirstChildOfType((Class)clazz2)).getImage());
        attr = (ASTAttribute)attrsList.get(1);
        Assert.assertEquals((String)"Correct attribute name expected!", (Object)"href", (Object)attr.getName());
        Class<?> clazz3 = class$net$sourceforge$pmd$jsp$ast$ASTAttributeValue;
        if (clazz3 == null) {
            clazz3 = class$net$sourceforge$pmd$jsp$ast$ASTAttributeValue = new ASTAttributeValue[0].getClass().getComponentType();
        }
        Assert.assertEquals((String)"Correct attribute value expected!", (Object)"#", (Object)((ASTAttributeValue)attr.getFirstChildOfType((Class)clazz3)).getImage());
        attr = (ASTAttribute)attrsList.get(2);
        Assert.assertEquals((String)"Correct attribute name expected!", (Object)"something", (Object)attr.getName());
        Class<?> clazz4 = class$net$sourceforge$pmd$jsp$ast$ASTAttributeValue;
        if (clazz4 == null) {
            clazz4 = class$net$sourceforge$pmd$jsp$ast$ASTAttributeValue = new ASTAttributeValue[0].getClass().getComponentType();
        }
        Assert.assertEquals((String)"Correct attribute value expected!", (Object)"#yes#", (Object)((ASTAttributeValue)attr.getFirstChildOfType((Class)clazz4)).getImage());
    }

    @org.junit.Test
    public void testCData() {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTCData;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTCData = new ASTCData[0].getClass().getComponentType();
        }
        Set cdataNodes = this.getNodes(clazz, TEST_CDATA);
        Assert.assertEquals((String)"One CDATA node expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)cdataNodes.size()));
        ASTCData cdata = (ASTCData)cdataNodes.iterator().next();
        Assert.assertEquals((String)"Content incorrectly parsed!", (Object)" some <cdata> ]] ]> ", (Object)cdata.getImage());
    }

    @org.junit.Test
    public void testDoctype() {
        Set nodes = this.getNodes(null, TEST_DOCTYPE);
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTDoctypeDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTDoctypeDeclaration = new ASTDoctypeDeclaration[0].getClass().getComponentType();
        }
        Set docTypeDeclarations = this.getNodesOfType(clazz, nodes);
        Assert.assertEquals((String)"One doctype declaration expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)docTypeDeclarations.size()));
        ASTDoctypeDeclaration docTypeDecl = (ASTDoctypeDeclaration)docTypeDeclarations.iterator().next();
        Assert.assertEquals((String)"Correct doctype-name expected!", (Object)"html", (Object)docTypeDecl.getName());
        Class<?> clazz2 = class$net$sourceforge$pmd$jsp$ast$ASTDoctypeExternalId;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$jsp$ast$ASTDoctypeExternalId = new ASTDoctypeExternalId[0].getClass().getComponentType();
        }
        Set externalIds = this.getNodesOfType(clazz2, nodes);
        Assert.assertEquals((String)"One doctype external id expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)externalIds.size()));
        ASTDoctypeExternalId externalId = (ASTDoctypeExternalId)externalIds.iterator().next();
        Assert.assertEquals((String)"Correct external public id expected!", (Object)"-//W3C//DTD XHTML 1.1//EN", (Object)externalId.getPublicId());
        Assert.assertEquals((String)"Correct external uri expected!", (Object)"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", (Object)externalId.getUri());
    }

    @org.junit.Test
    public void testComment() {
        Class<?> clazz = class$net$sourceforge$pmd$jsp$ast$ASTCommentTag;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$jsp$ast$ASTCommentTag = new ASTCommentTag[0].getClass().getComponentType();
        }
        Set comments = this.getNodes(clazz, TEST_COMMENT);
        Assert.assertEquals((String)"One comment expected!", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)comments.size()));
        ASTCommentTag comment = (ASTCommentTag)comments.iterator().next();
        Assert.assertEquals((String)"Correct comment content expected!", (Object)"comment", (Object)comment.getImage());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$jsp$ast$JspDocStyleTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$jsp$ast$JspDocStyleTest = new JspDocStyleTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

