/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.jaxen;

import java.util.Iterator;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTStatement;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.net.sourceforge.pmd.testframework.RuleTst;

public class DocumentNavigatorTest
extends RuleTst {
    private TestRule rule;
    public static final String TEST = "import java.io.*;" + PMD.EOL + "public class Foo {" + PMD.EOL + " public Foo() {" + PMD.EOL + "  try {" + PMD.EOL + "   FileReader fr = new FileReader(\"/dev/null\");" + PMD.EOL + "  } catch (Exception e) {}" + PMD.EOL + "  try {" + PMD.EOL + "   FileReader fr = new FileReader(\"/dev/null\");" + PMD.EOL + "  } catch (Exception e) {" + PMD.EOL + "   e.printStackTrace();" + PMD.EOL + "   // this shouldn't show up on the report" + PMD.EOL + "  }" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$jaxen$DocumentNavigatorTest;

    @Before
    public void setUp() throws Exception {
        try {
            this.rule = new TestRule();
            this.runTestFromString(TEST, (Rule)this.rule, new Report());
        }
        catch (Throwable xx) {
            xx.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testChildAxisIterator() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getChildAxisIterator((Object)this.rule.compilationUnit);
        Assert.assertSame((Object)this.rule.compilationUnit.jjtGetChild(0), iter.next());
        Assert.assertSame((Object)this.rule.compilationUnit.jjtGetChild(1), iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testParentAxisIterator() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getParentAxisIterator((Object)this.rule.importDeclaration);
        Assert.assertSame((Object)this.rule.importDeclaration.jjtGetParent(), iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testParentAxisIterator2() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getParentAxisIterator((Object)this.rule.compilationUnit);
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testDescendantAxisIterator() throws UnsupportedAxisException {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getDescendantAxisIterator((Object)this.rule.statement);
        Node statementExpression = this.rule.statement.jjtGetChild(0);
        Assert.assertSame((Object)statementExpression, iter.next());
        Node primaryExpression = statementExpression.jjtGetChild(0);
        Assert.assertSame((Object)primaryExpression, iter.next());
        Node primaryPrefix = primaryExpression.jjtGetChild(0);
        Assert.assertSame((Object)primaryPrefix, iter.next());
        Node primarySuffix = primaryExpression.jjtGetChild(1);
        Node name = primaryPrefix.jjtGetChild(0);
        Node arguments = primarySuffix.jjtGetChild(0);
    }

    @Test
    public void testDescendantAxisIterator2() throws UnsupportedAxisException {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getDescendantAxisIterator((Object)this.rule.primaryPrefix);
        Node name = this.rule.primaryPrefix.jjtGetChild(0);
        Assert.assertSame((Object)name, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testFollowingSiblingAxisIterator() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getFollowingSiblingAxisIterator((Object)this.rule.primaryExpression.jjtGetChild(0));
        Assert.assertSame((Object)this.rule.primaryExpression.jjtGetChild(1), iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testFollowingSiblingAxisIterator2() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getFollowingSiblingAxisIterator((Object)this.rule.primaryExpression.jjtGetChild(1));
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testPrecedingSiblingAxisIterator() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getPrecedingSiblingAxisIterator((Object)this.rule.primaryExpression.jjtGetChild(1));
        Assert.assertSame((Object)this.rule.primaryExpression.jjtGetChild(0), iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testPrecedingSiblingAxisIterator2() {
        DocumentNavigator nav = new DocumentNavigator();
        Iterator iter = nav.getPrecedingSiblingAxisIterator((Object)this.rule.primaryExpression.jjtGetChild(0));
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testXPath() throws JaxenException {
        BaseXPath xPath = new BaseXPath(".//*", (Navigator)new DocumentNavigator());
        List matches = xPath.selectNodes((Object)this.rule.statement);
        Assert.assertEquals((Object)Integer_.valueOf((int)6), (Object)Integer_.valueOf((int)matches.size()));
    }

    @Test
    public void testXPath2() throws JaxenException {
        BaseXPath xPath = new BaseXPath(".//*", (Navigator)new DocumentNavigator());
        List matches = xPath.selectNodes((Object)this.rule.importDeclaration);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)matches.size()));
    }

    public static junit.framework.Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$jaxen$DocumentNavigatorTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$jaxen$DocumentNavigatorTest = new DocumentNavigatorTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }

    private class TestRule
    extends AbstractRule {
        private Node compilationUnit;
        private Node importDeclaration;
        private Node statement;
        private Node primaryPrefix;
        private Node primaryExpression;

        private TestRule() {
        }

        public Object visit(ASTCompilationUnit node, Object data) {
            this.compilationUnit = node;
            return super.visit(node, data);
        }

        public Object visit(ASTImportDeclaration node, Object data) {
            this.importDeclaration = node;
            return super.visit(node, data);
        }

        public Object visit(ASTStatement node, Object data) {
            this.statement = node;
            return super.visit(node, data);
        }

        public Object visit(ASTPrimaryPrefix node, Object data) {
            this.primaryPrefix = node;
            return super.visit(node, data);
        }

        public Object visit(ASTPrimaryExpression node, Object data) {
            this.primaryExpression = node;
            return super.visit(node, data);
        }
    }
}

