/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.dfa;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.dfa.DataFlowNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.StatementAndBraceFinder;
import org.junit.Assert;
import test.net.sourceforge.pmd.testframework.ParserTst;

public class StatementAndBraceFinderTest
extends ParserTst {
    private static final String TEST1 = "class Foo {" + PMD.EOL + " void bar() {" + PMD.EOL + "  x = 2;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST2 = "class Foo {" + PMD.EOL + " void bar() {" + PMD.EOL + "  int x;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST3 = "class Foo {" + PMD.EOL + " void bar() {" + PMD.EOL + "  if (x) {}" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST4 = "class Foo {" + PMD.EOL + " void bar() {" + PMD.EOL + "  while (x) {}" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String TEST5 = "class Foo {" + PMD.EOL + " void bar() {" + PMD.EOL + "  for (int i=0; i<10; i++) {}" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTVariableDeclarator;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$dfa$StatementAndBraceFinderTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTStatementExpression;

    @org.junit.Test
    public void testStatementExpressionParentChildLinks() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTStatementExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTStatementExpression = new ASTStatementExpression[0].getClass().getComponentType();
        }
        ASTStatementExpression se = (ASTStatementExpression)this.getOrderedNodes(clazz, TEST1).get(0);
        ASTMethodDeclaration seParent = (ASTMethodDeclaration)((DataFlowNode)se.getDataFlowNode().getParents().get(0)).getSimpleNode();
        Assert.assertEquals((Object)se, (Object)((IDataFlowNode)seParent.getDataFlowNode().getChildren().get(0)).getSimpleNode());
        Assert.assertEquals((Object)seParent, (Object)((IDataFlowNode)se.getDataFlowNode().getParents().get(0)).getSimpleNode());
    }

    @org.junit.Test
    public void testVariableDeclaratorParentChildLinks() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclarator;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTVariableDeclarator = new ASTVariableDeclarator[0].getClass().getComponentType();
        }
        ASTVariableDeclarator vd = (ASTVariableDeclarator)this.getOrderedNodes(clazz, TEST2).get(0);
        ASTMethodDeclaration vdParent = (ASTMethodDeclaration)((DataFlowNode)vd.getDataFlowNode().getParents().get(0)).getSimpleNode();
        Assert.assertEquals((Object)vd, (Object)((IDataFlowNode)vdParent.getDataFlowNode().getChildren().get(0)).getSimpleNode());
        Assert.assertEquals((Object)vdParent, (Object)((IDataFlowNode)vd.getDataFlowNode().getParents().get(0)).getSimpleNode());
    }

    @org.junit.Test
    public void testIfStmtHasCorrectTypes() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTExpression = new ASTExpression[0].getClass().getComponentType();
        }
        ASTExpression exp = (ASTExpression)this.getOrderedNodes(clazz, TEST3).get(0);
        IDataFlowNode dfn = (IDataFlowNode)exp.getDataFlowNode().getFlow().get(2);
        Assert.assertTrue((boolean)dfn.isType(1));
        Assert.assertTrue((boolean)dfn.isType(3));
    }

    @org.junit.Test
    public void testWhileStmtHasCorrectTypes() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTExpression = new ASTExpression[0].getClass().getComponentType();
        }
        ASTExpression exp = (ASTExpression)this.getOrderedNodes(clazz, TEST4).get(0);
        IDataFlowNode dfn = (IDataFlowNode)exp.getDataFlowNode().getFlow().get(2);
        Assert.assertTrue((boolean)dfn.isType(10));
        Assert.assertTrue((boolean)dfn.isType(11));
    }

    @org.junit.Test
    public void testForStmtHasCorrectTypes() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTExpression = new ASTExpression[0].getClass().getComponentType();
        }
        ASTExpression exp = (ASTExpression)this.getOrderedNodes(clazz, TEST5).get(0);
        IDataFlowNode dfn = (IDataFlowNode)exp.getDataFlowNode().getFlow().get(2);
        Assert.assertTrue((boolean)dfn.isType(30));
        dfn = (IDataFlowNode)exp.getDataFlowNode().getFlow().get(3);
        Assert.assertTrue((boolean)dfn.isType(31));
        dfn = (IDataFlowNode)exp.getDataFlowNode().getFlow().get(4);
        Assert.assertTrue((boolean)dfn.isType(32));
        Assert.assertTrue((boolean)dfn.isType(33));
        Assert.assertTrue((boolean)dfn.isType(34));
    }

    @org.junit.Test(expected=RuntimeException.class)
    public void testOnlyWorksForMethodsAndConstructors() {
        StatementAndBraceFinder sbf = new StatementAndBraceFinder();
        sbf.buildDataFlowFor((SimpleJavaNode)new ASTMethodDeclaration(1));
        sbf.buildDataFlowFor((SimpleJavaNode)new ASTConstructorDeclaration(1));
        sbf.buildDataFlowFor((SimpleJavaNode)new ASTCompilationUnit(1));
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$dfa$StatementAndBraceFinderTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$dfa$StatementAndBraceFinderTest = new StatementAndBraceFinderTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

