/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLRendererTest {
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$cpd$XMLRendererTest;

    @org.junit.Test
    public void test_no_dupes() {
        XMLRenderer renderer = new XMLRenderer();
        ArrayList list = new ArrayList();
        String report = renderer.render(list.iterator());
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(report.getBytes()));
            NodeList nodes = doc.getChildNodes();
            Node n = nodes.item(0);
            Assert.assertEquals((Object)"pmd-cpd", (Object)n.getNodeName());
            Assert.assertEquals((Object)Integer_.valueOf((int)0), (Object)Integer_.valueOf((int)doc.getElementsByTagName("duplication").getLength()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @org.junit.Test
    public void test_one_dupe() {
        XMLRenderer renderer = new XMLRenderer();
        ArrayList<Match> list = new ArrayList<Match>();
        Match match = new Match(75, new TokenEntry("public", "/var/Foo.java", 48), new TokenEntry("stuff", "/var/Foo.java", 73));
        match.setLineCount(6);
        match.setSourceCodeSlice("code fragment");
        list.add(match);
        String report = renderer.render(list.iterator());
        try {
            Node file;
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(report.getBytes()));
            NodeList dupes = doc.getElementsByTagName("duplication");
            Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)dupes.getLength()));
            for (file = dupes.item(0).getFirstChild(); file != null && file.getNodeType() != 1; file = file.getNextSibling()) {
            }
            Assert.assertEquals((Object)"48", (Object)file.getAttributes().getNamedItem("line").getNodeValue());
            Assert.assertEquals((Object)"/var/Foo.java", (Object)file.getAttributes().getNamedItem("path").getNodeValue());
            for (file = file.getNextSibling(); file != null && file.getNodeType() != 1; file = file.getNextSibling()) {
            }
            Assert.assertEquals((Object)"73", (Object)file.getAttributes().getNamedItem("line").getNodeValue());
            Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)doc.getElementsByTagName("codefragment").getLength()));
            Node actualCode = doc.getElementsByTagName("codefragment").item(0).getFirstChild().getNextSibling();
            Assert.assertEquals((Object)"\ncode fragment\n", (Object)actualCode.getNodeValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @org.junit.Test
    public void testRender_MultipleMatch() {
        XMLRenderer renderer = new XMLRenderer();
        ArrayList<Match> list = new ArrayList<Match>();
        Match match1 = new Match(75, new TokenEntry("public", "/var/Foo.java", 48), new TokenEntry("void", "/var/Foo.java", 73));
        match1.setLineCount(6);
        match1.setSourceCodeSlice("code fragment");
        Match match2 = new Match(76, new TokenEntry("void", "/var/Foo2.java", 49), new TokenEntry("stuff", "/var/Foo2.java", 74));
        match2.setLineCount(7);
        match2.setSourceCodeSlice("code fragment 2");
        list.add(match1);
        list.add(match2);
        String report = renderer.render(list.iterator());
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(report.getBytes()));
            Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)doc.getElementsByTagName("duplication").getLength()));
            Assert.assertEquals((Object)Integer_.valueOf((int)4), (Object)Integer_.valueOf((int)doc.getElementsByTagName("file").getLength()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$cpd$XMLRendererTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$cpd$XMLRendererTest = new XMLRendererTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

