/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.CPPTokenizer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;

public class CPPTokenizerTest {
    private static final String TEST1 = "#define FOO a +\\" + PMD.EOL + "            b +\\" + PMD.EOL + "            c +\\" + PMD.EOL + "            d +\\" + PMD.EOL + "            e +\\" + PMD.EOL + "            f +\\" + PMD.EOL + "            g" + PMD.EOL + " void main() {}";
    private static final String TEST2 = " void main() { int x$y = 42; }";
    private static final String TEST3 = " void main() { int $x = 42; }";
    private static final String TEST4 = " void main() { char x = L'a'; }";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$cpd$CPPTokenizerTest;

    @org.junit.Test
    public void testMultiLineMacros() throws Throwable {
        CPPTokenizer tokenizer = new CPPTokenizer();
        SourceCode code = new SourceCode((SourceCode.CodeLoader)new SourceCode.StringCodeLoader(TEST1));
        Tokens tokens = new Tokens();
        tokenizer.tokenize(code, tokens);
        Assert.assertEquals((Object)Integer_.valueOf((int)7), (Object)Integer_.valueOf((int)tokens.size()));
    }

    @org.junit.Test
    public void testDollarSignInIdentifier() {
        this.parse(TEST2);
    }

    @org.junit.Test
    public void testDollarSignStartingIdentifier() {
        this.parse(TEST3);
    }

    @org.junit.Test
    public void testWideCharacters() {
        this.parse(TEST4);
    }

    private void parse(String snippet) {
        CPPTokenizer tokenizer = new CPPTokenizer();
        SourceCode code = new SourceCode((SourceCode.CodeLoader)new SourceCode.StringCodeLoader(snippet));
        Tokens tokens = new Tokens();
        tokenizer.tokenize(code, tokens);
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$cpd$CPPTokenizerTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$cpd$CPPTokenizerTest = new CPPTokenizerTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

