/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTBlock;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTExtendsList;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTImplementsList;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.ast.ASTStatement;
import net.sourceforge.pmd.ast.ASTVariableInitializer;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import test.net.sourceforge.pmd.testframework.ParserTst;

public class SimpleNodeTest
extends ParserTst {
    private static final String HAS_EXPLICIT_EXTENDS = "public class Test extends Foo {}";
    private static final String NO_EXPLICIT_EXTENDS = "public class Test {}";
    private static final String HAS_EXPLICIT_IMPLEMENTS = "public class Test implements Foo {}";
    private static final String NO_EXPLICIT_IMPLEMENTS = "public class Test {}";
    private static final String METHOD_SAME_LINE = "public class Test {" + PMD.EOL + " public void foo() {}" + PMD.EOL + "}";
    private static final String QUALIFIED_NAME = "import java.io.File;" + PMD.EOL + "public class Foo{}";
    private static final String BROKEN_LINE_IN_NAME = "import java.io." + PMD.EOL + "File;" + PMD.EOL + "public class Foo{}";
    private static final String LINE_NUMBERS_ON_SIBLINGS = "public class Foo {" + PMD.EOL + " void bar() {" + PMD.EOL + "  try {" + PMD.EOL + "  } catch (Exception1 e) {" + PMD.EOL + "   int x =2;" + PMD.EOL + "  }" + PMD.EOL + " if (x != null) {}" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String NO_LOOKAHEAD = "public class Foo { }";
    private static final String METHOD_DIFF_LINES = "public class Test {" + PMD.EOL + " public void foo() {" + PMD.EOL + "  int x;" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final String CONTAINS_CHILDREN_OF_TYPE = "public class Test {" + PMD.EOL + "  int x;" + PMD.EOL + "}";
    private static final String CONTAINS_NO_INNER = "public class Test {" + PMD.EOL + "  public class Inner {" + PMD.EOL + "   int foo;" + PMD.EOL + "  }" + PMD.EOL + "}";
    private static final String CONTAINS_NO_INNER_WITH_ANON_INNER = "public class Test {" + PMD.EOL + "  void bar() {" + PMD.EOL + "   foo(new Fuz() { int x = 2;});" + PMD.EOL + "  }" + PMD.EOL + "}";
    private static final String TEST_XPATH = "public class Test {" + PMD.EOL + "  int x = 2;" + PMD.EOL + "  int y = 42;" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTReturnStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTBlock;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ast$SimpleNodeTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTBlockStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTVariableInitializer;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTCompilationUnit;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAssignmentOperator;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;

    @Test
    public void testMethodDiffLines() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
        }
        Set methods = this.getNodes(clazz, METHOD_DIFF_LINES);
        Iterator iter = methods.iterator();
        this.verifyNode((SimpleNode)iter.next(), 2, 9, 4, 2);
    }

    @Test
    public void testMethodSameLine() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
        }
        Set methods = this.getNodes(clazz, METHOD_SAME_LINE);
        this.verifyNode((SimpleNode)methods.iterator().next(), 2, 9, 2, 21);
    }

    @Test
    public void testNoLookahead() throws Throwable {
        String code = NO_LOOKAHEAD;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        Set uCD = this.getNodes(clazz, code);
        this.verifyNode((SimpleNode)uCD.iterator().next(), 1, 8, 1, 20);
    }

    @Test
    public void testHasExplicitExtends() throws Throwable {
        String code = HAS_EXPLICIT_EXTENDS;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration ucd = (ASTClassOrInterfaceDeclaration)this.getNodes(clazz, code).iterator().next();
        Assert.assertTrue((boolean)(ucd.jjtGetChild(0) instanceof ASTExtendsList));
    }

    @Test
    public void testNoExplicitExtends() throws Throwable {
        String code = "public class Test {}";
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration ucd = (ASTClassOrInterfaceDeclaration)this.getNodes(clazz, code).iterator().next();
        Assert.assertFalse((boolean)(ucd.jjtGetChild(0) instanceof ASTExtendsList));
    }

    @Test
    public void testHasExplicitImplements() throws Throwable {
        String code = HAS_EXPLICIT_IMPLEMENTS;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration ucd = (ASTClassOrInterfaceDeclaration)this.getNodes(clazz, code).iterator().next();
        Assert.assertTrue((boolean)(ucd.jjtGetChild(0) instanceof ASTImplementsList));
    }

    @Test
    public void testNoExplicitImplements() throws Throwable {
        String code = "public class Test {}";
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration ucd = (ASTClassOrInterfaceDeclaration)this.getNodes(clazz, code).iterator().next();
        Assert.assertFalse((boolean)(ucd.jjtGetChild(0) instanceof ASTImplementsList));
    }

    @Test
    public void testColumnsOnQualifiedName() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTName;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTName = new ASTName[0].getClass().getComponentType();
        }
        Set name = this.getNodes(clazz, QUALIFIED_NAME);
        Iterator i = name.iterator();
        while (i.hasNext()) {
            SimpleNode node = (SimpleNode)i.next();
            if (!node.getImage().equals("java.io.File")) continue;
            this.verifyNode(node, 1, 8, 1, 19);
        }
    }

    @Test
    public void testLineNumbersForNameSplitOverTwoLines() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTName;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTName = new ASTName[0].getClass().getComponentType();
        }
        Set name = this.getNodes(clazz, BROKEN_LINE_IN_NAME);
        Iterator i = name.iterator();
        while (i.hasNext()) {
            SimpleNode node = (SimpleNode)i.next();
            if (node.getImage().equals("java.io.File")) {
                this.verifyNode(node, 1, 8, 2, 4);
            }
            if (!node.getImage().equals("Foo")) continue;
            this.verifyNode(node, 2, 15, 2, 18);
        }
    }

    @Test
    public void testLineNumbersAreSetOnAllSiblings() throws Throwable {
        ASTBlock b;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTBlock;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTBlock = new ASTBlock[0].getClass().getComponentType();
        }
        Set blocks = this.getNodes(clazz, LINE_NUMBERS_ON_SIBLINGS);
        Iterator i = blocks.iterator();
        while (i.hasNext()) {
            b = (ASTBlock)i.next();
            Assert.assertTrue((b.getBeginLine() > 0 ? 1 : 0) != 0);
        }
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTVariableInitializer;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTVariableInitializer = new ASTVariableInitializer[0].getClass().getComponentType();
        }
        blocks = this.getNodes(clazz2, LINE_NUMBERS_ON_SIBLINGS);
        i = blocks.iterator();
        while (i.hasNext()) {
            b = (ASTVariableInitializer)i.next();
            Assert.assertTrue((b.getBeginLine() > 0 ? 1 : 0) != 0);
        }
        Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTExpression;
        if (clazz3 == null) {
            clazz3 = class$net$sourceforge$pmd$ast$ASTExpression = new ASTExpression[0].getClass().getComponentType();
        }
        blocks = this.getNodes(clazz3, LINE_NUMBERS_ON_SIBLINGS);
        i = blocks.iterator();
        while (i.hasNext()) {
            b = (ASTExpression)i.next();
            Assert.assertTrue((b.getBeginLine() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFindChildrenOfType() {
        ASTBlock block = new ASTBlock(2);
        block.jjtAddChild((Node)new ASTReturnStatement(1), 0);
        Integer n = Integer_.valueOf((int)1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTReturnStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTReturnStatement = new ASTReturnStatement[0].getClass().getComponentType();
        }
        Assert.assertEquals((Object)n, (Object)Integer_.valueOf((int)block.findChildrenOfType((Class)clazz).size()));
    }

    @Test
    public void testFindChildrenOfTypeMultiple() {
        ASTBlock block = new ASTBlock(1);
        block.jjtAddChild((Node)new ASTBlockStatement(2), 0);
        block.jjtAddChild((Node)new ASTBlockStatement(3), 1);
        ArrayList nodes = new ArrayList();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTBlockStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTBlockStatement = new ASTBlockStatement[0].getClass().getComponentType();
        }
        block.findChildrenOfType((Class)clazz, nodes);
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)nodes.size()));
    }

    @Test
    public void testFindChildrenOfTypeRecurse() {
        ASTBlock block = new ASTBlock(1);
        ASTBlock childBlock = new ASTBlock(2);
        block.jjtAddChild((Node)childBlock, 0);
        childBlock.jjtAddChild((Node)new ASTMethodDeclaration(3), 0);
        ArrayList nodes = new ArrayList();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
        }
        block.findChildrenOfType((Class)clazz, nodes);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)nodes.size()));
    }

    @Test
    public void testGetFirstChild() {
        ASTBlock block = new ASTBlock(1);
        ASTStatement x = new ASTStatement(2);
        block.jjtAddChild((Node)x, 0);
        block.jjtAddChild((Node)new ASTStatement(3), 1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTStatement = new ASTStatement[0].getClass().getComponentType();
        }
        Node n = (Node)block.getFirstChildOfType((Class)clazz);
        Assert.assertNotNull((Object)n);
        Assert.assertTrue((boolean)(n instanceof ASTStatement));
        Assert.assertEquals((Object)x, (Object)n);
    }

    @Test
    public void testGetFirstChildNested() {
        ASTBlock block = new ASTBlock(1);
        ASTStatement x = new ASTStatement(2);
        ASTAssignmentOperator x1 = new ASTAssignmentOperator(4);
        x.jjtAddChild((Node)x1, 1);
        block.jjtAddChild((Node)x, 0);
        block.jjtAddChild((Node)new ASTStatement(3), 1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTAssignmentOperator;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTAssignmentOperator = new ASTAssignmentOperator[0].getClass().getComponentType();
        }
        Node n = (Node)block.getFirstChildOfType((Class)clazz);
        Assert.assertNotNull((Object)n);
        Assert.assertTrue((boolean)(n instanceof ASTAssignmentOperator));
        Assert.assertEquals((Object)x1, (Object)n);
    }

    @Test
    public void testGetFirstChildNestedDeeper() {
        ASTBlock block = new ASTBlock(1);
        ASTStatement x = new ASTStatement(2);
        ASTAssignmentOperator x1 = new ASTAssignmentOperator(4);
        ASTName x2 = new ASTName(5);
        x.jjtAddChild((Node)x1, 1);
        x1.jjtAddChild((Node)x2, 0);
        block.jjtAddChild((Node)x, 0);
        block.jjtAddChild((Node)new ASTStatement(3), 1);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTName;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTName = new ASTName[0].getClass().getComponentType();
        }
        Node n = (Node)block.getFirstChildOfType((Class)clazz);
        Assert.assertNotNull((Object)n);
        Assert.assertTrue((boolean)(n instanceof ASTName));
        Assert.assertEquals((Object)x2, (Object)n);
    }

    @Ignore
    @Test
    public void testContainsNoInner() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTCompilationUnit;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTCompilationUnit = new ASTCompilationUnit[0].getClass().getComponentType();
        }
        ASTCompilationUnit c = (ASTCompilationUnit)this.getNodes(clazz, CONTAINS_NO_INNER).iterator().next();
        ArrayList res = new ArrayList();
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
        }
        c.findChildrenOfType((Class)clazz2, res, false);
        Assert.assertTrue((boolean)res.isEmpty());
    }

    @Test
    public void testContainsNoInnerWithAnonInner() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTCompilationUnit;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTCompilationUnit = new ASTCompilationUnit[0].getClass().getComponentType();
        }
        ASTCompilationUnit c = (ASTCompilationUnit)this.getNodes(clazz, CONTAINS_NO_INNER_WITH_ANON_INNER).iterator().next();
        ArrayList res = new ArrayList();
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
        }
        c.findChildrenOfType((Class)clazz2, res, false);
        Assert.assertTrue((boolean)res.isEmpty());
    }

    @Test
    public void testContainsChildOfType() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration c = (ASTClassOrInterfaceDeclaration)this.getNodes(clazz, CONTAINS_CHILDREN_OF_TYPE).iterator().next();
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
        }
        Assert.assertTrue((boolean)c.containsChildOfType((Class)clazz2));
    }

    @Test
    public void testXPathNodeSelect() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        ASTClassOrInterfaceDeclaration c = (ASTClassOrInterfaceDeclaration)this.getNodes(clazz, TEST_XPATH).iterator().next();
        List nodes = c.findChildNodesWithXPath("//FieldDeclaration");
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)nodes.size()));
        Assert.assertTrue((boolean)(nodes.get(0) instanceof ASTFieldDeclaration));
    }

    private void verifyNode(SimpleNode node, int beginLine, int beginCol, int endLine, int endCol) {
        Assert.assertEquals((String)"Unexpected beginning line: ", (Object)Integer_.valueOf((int)beginLine), (Object)Integer_.valueOf((int)node.getBeginLine()));
        Assert.assertEquals((String)"Unexpected beginning column: ", (Object)Integer_.valueOf((int)beginCol), (Object)Integer_.valueOf((int)node.getBeginColumn()));
        Assert.assertEquals((String)"Unexpected ending line:", (Object)Integer_.valueOf((int)endLine), (Object)Integer_.valueOf((int)node.getEndLine()));
        Assert.assertEquals((String)"Unexpected ending column:", (Object)Integer_.valueOf((int)endCol), (Object)Integer_.valueOf((int)node.getEndColumn()));
    }

    public static junit.framework.Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ast$SimpleNodeTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ast$SimpleNodeTest = new SimpleNodeTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

