/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.util.Iterator;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.testframework.ParserTst;

public class FieldDeclTest
extends ParserTst {
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ast$FieldDeclTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFieldDeclaration;

    public String makeAccessJavaCode(String[] access) {
        String result = "public class Test { ";
        for (int i = 0; i < access.length; ++i) {
            result = result + access[i] + " ";
        }
        return result + " int j;  }";
    }

    public ASTFieldDeclaration getFieldDecl(String[] access) throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTFieldDeclaration = new ASTFieldDeclaration[0].getClass().getComponentType();
        }
        Set fields = this.getNodes(clazz, this.makeAccessJavaCode(access));
        Assert.assertEquals((String)"Wrong number of fields", (Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)fields.size()));
        Iterator i = fields.iterator();
        return (ASTFieldDeclaration)i.next();
    }

    @org.junit.Test
    public void testPublic() throws Throwable {
        String[] access = new String[]{"public"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be public.", (boolean)afd.isPublic());
    }

    @org.junit.Test
    public void testProtected() throws Throwable {
        String[] access = new String[]{"protected"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be protected.", (boolean)afd.isProtected());
    }

    @org.junit.Test
    public void testPrivate() throws Throwable {
        String[] access = new String[]{"private"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be private.", (boolean)afd.isPrivate());
    }

    @org.junit.Test
    public void testStatic() throws Throwable {
        String[] access = new String[]{"private", "static"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be static.", (boolean)afd.isStatic());
        Assert.assertTrue((String)"Expecting field to be private.", (boolean)afd.isPrivate());
    }

    @org.junit.Test
    public void testFinal() throws Throwable {
        String[] access = new String[]{"public", "final"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be final.", (boolean)afd.isFinal());
        Assert.assertTrue((String)"Expecting field to be public.", (boolean)afd.isPublic());
    }

    @org.junit.Test
    public void testTransient() throws Throwable {
        String[] access = new String[]{"private", "transient"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be private.", (boolean)afd.isPrivate());
        Assert.assertTrue((String)"Expecting field to be transient.", (boolean)afd.isTransient());
    }

    @org.junit.Test
    public void testVolatile() throws Throwable {
        String[] access = new String[]{"private", "volatile"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be volatile.", (boolean)afd.isVolatile());
        Assert.assertTrue((String)"Expecting field to be private.", (boolean)afd.isPrivate());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ast$FieldDeclTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ast$FieldDeclTest = new FieldDeclTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

