/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.AccessNode;
import org.junit.Assert;
import test.net.sourceforge.pmd.testframework.ParserTst;

public class AccessNodeTest
extends ParserTst {
    private static final String TEST1 = "public class Foo {}";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ast$AccessNodeTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;

    @org.junit.Test
    public void testModifiersOnClassDecl() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        Set ops = this.getNodes(clazz, TEST1);
        Assert.assertTrue((boolean)((ASTClassOrInterfaceDeclaration)ops.iterator().next()).isPublic());
    }

    @org.junit.Test
    public void testStatic() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not static.", (boolean)node.isStatic());
        node.setStatic();
        Assert.assertTrue((String)"Node set to static, not static.", (boolean)node.isStatic());
    }

    @org.junit.Test
    public void testPublic() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not public.", (boolean)node.isPublic());
        node.setPublic();
        Assert.assertTrue((String)"Node set to public, not public.", (boolean)node.isPublic());
    }

    @org.junit.Test
    public void testProtected() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not protected.", (boolean)node.isProtected());
        node.setProtected();
        Assert.assertTrue((String)"Node set to protected, not protected.", (boolean)node.isProtected());
    }

    @org.junit.Test
    public void testPrivate() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not private.", (boolean)node.isPrivate());
        node.setPrivate();
        Assert.assertTrue((String)"Node set to private, not private.", (boolean)node.isPrivate());
    }

    @org.junit.Test
    public void testFinal() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not final.", (boolean)node.isFinal());
        node.setFinal();
        Assert.assertTrue((String)"Node set to final, not final.", (boolean)node.isFinal());
    }

    @org.junit.Test
    public void testSynchronized() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not synchronized.", (boolean)node.isSynchronized());
        node.setSynchronized();
        Assert.assertTrue((String)"Node set to synchronized, not synchronized.", (boolean)node.isSynchronized());
    }

    @org.junit.Test
    public void testVolatile() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not volatile.", (boolean)node.isVolatile());
        node.setVolatile();
        Assert.assertTrue((String)"Node set to volatile, not volatile.", (boolean)node.isVolatile());
    }

    @org.junit.Test
    public void testTransient() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not transient.", (boolean)node.isTransient());
        node.setTransient();
        Assert.assertTrue((String)"Node set to transient, not transient.", (boolean)node.isTransient());
    }

    @org.junit.Test
    public void testNative() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not native.", (boolean)node.isNative());
        node.setNative();
        Assert.assertTrue((String)"Node set to native, not native.", (boolean)node.isNative());
    }

    @org.junit.Test
    public void testAbstract() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not abstract.", (boolean)node.isAbstract());
        node.setAbstract();
        Assert.assertTrue((String)"Node set to abstract, not abstract.", (boolean)node.isAbstract());
    }

    @org.junit.Test
    public void testStrict() {
        AccessNode node = new AccessNode(1);
        Assert.assertFalse((String)"Node should default to not strict.", (boolean)node.isStrictfp());
        node.setStrictfp();
        Assert.assertTrue((String)"Node set to strict, not strict.", (boolean)node.isStrictfp());
    }

    @org.junit.Test
    public void testPackagePrivate() {
        AccessNode node = new AccessNode(1);
        Assert.assertTrue((String)"Node should default to package private.", (boolean)node.isPackagePrivate());
        node.setPrivate();
        Assert.assertFalse((String)"Node set to private, still package private.", (boolean)node.isPackagePrivate());
        node = new AccessNode(1);
        node.setPublic();
        Assert.assertFalse((String)"Node set to public, still package private.", (boolean)node.isPackagePrivate());
        node = new AccessNode(1);
        node.setProtected();
        Assert.assertFalse((String)"Node set to protected, still package private.", (boolean)node.isPackagePrivate());
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ast$AccessNodeTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ast$AccessNodeTest = new AccessNodeTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

