/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.TargetJDK1_4;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import test.net.sourceforge.pmd.testframework.ParserTst;

public class ASTLocalVariableDeclarationTest
extends ParserTst {
    private static final String TEST1 = "class Foo {" + PMD.EOL + " void bar() {int x[] = null;}" + PMD.EOL + "}";
    private static final String TEST2 = "class Foo {" + PMD.EOL + " void bar() {int x[][] = null;}" + PMD.EOL + "}";
    private static final String TEST3 = "class Foo {" + PMD.EOL + " void bar() {int[] x[][] = null;}" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ast$ASTLocalVariableDeclarationTest;

    @org.junit.Test
    public void testSingleDimArray() {
        JavaParser parser = new TargetJDK1_4().createParser((Reader)new StringReader(TEST1));
        ASTCompilationUnit cu = parser.CompilationUnit();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration = new ASTLocalVariableDeclaration[0].getClass().getComponentType();
        }
        ASTLocalVariableDeclaration node = (ASTLocalVariableDeclaration)cu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)node.getArrayDepth()));
    }

    @org.junit.Test
    public void testMultDimArray() {
        JavaParser parser = new TargetJDK1_4().createParser((Reader)new StringReader(TEST2));
        ASTCompilationUnit cu = parser.CompilationUnit();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration = new ASTLocalVariableDeclaration[0].getClass().getComponentType();
        }
        ASTLocalVariableDeclaration node = (ASTLocalVariableDeclaration)cu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertEquals((Object)Integer_.valueOf((int)2), (Object)Integer_.valueOf((int)node.getArrayDepth()));
    }

    @org.junit.Test
    public void testMultDimArraySplitBraces() {
        JavaParser parser = new TargetJDK1_4().createParser((Reader)new StringReader(TEST3));
        ASTCompilationUnit cu = parser.CompilationUnit();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration = new ASTLocalVariableDeclaration[0].getClass().getComponentType();
        }
        ASTLocalVariableDeclaration node = (ASTLocalVariableDeclaration)cu.findChildrenOfType((Class)clazz).get(0);
        Assert.assertEquals((Object)Integer_.valueOf((int)3), (Object)Integer_.valueOf((int)node.getArrayDepth()));
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ast$ASTLocalVariableDeclarationTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ast$ASTLocalVariableDeclarationTest = new ASTLocalVariableDeclarationTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

