/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.TargetJDK1_5;
import net.sourceforge.pmd.TargetJDKVersion;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ParseException;
import org.junit.Assert;
import test.net.sourceforge.pmd.testframework.ParserTst;

public class ASTImportDeclarationTest
extends ParserTst {
    private static final String TEST1 = "import foo.bar.*;" + PMD.EOL + "public class Foo {}";
    private static final String TEST2 = "import foo.bar.Baz;" + PMD.EOL + "public class Foo {}";
    private static final String TEST3 = "import static foo.bar.Baz;" + PMD.EOL + "public class Foo {}";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ast$ASTImportDeclarationTest;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTImportDeclaration;

    @org.junit.Test
    public void testImportOnDemand() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTImportDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTImportDeclaration = new ASTImportDeclaration[0].getClass().getComponentType();
        }
        Set ops = this.getNodes(clazz, TEST1);
        Assert.assertTrue((boolean)((ASTImportDeclaration)ops.iterator().next()).isImportOnDemand());
    }

    @org.junit.Test
    public void testGetImportedNameNode() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTImportDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTImportDeclaration = new ASTImportDeclaration[0].getClass().getComponentType();
        }
        ASTImportDeclaration i = (ASTImportDeclaration)this.getNodes(clazz, TEST2).iterator().next();
        Assert.assertEquals((Object)"foo.bar.Baz", (Object)i.getImportedName());
    }

    @org.junit.Test
    public void testStaticImport() throws Throwable {
        TargetJDK1_5 targetJDK1_5 = new TargetJDK1_5();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTImportDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTImportDeclaration = new ASTImportDeclaration[0].getClass().getComponentType();
        }
        Set ops = this.getNodes((TargetJDKVersion)targetJDK1_5, clazz, TEST3);
        ASTImportDeclaration i = (ASTImportDeclaration)ops.iterator().next();
        Assert.assertTrue((boolean)i.isStatic());
    }

    @org.junit.Test(expected=ParseException.class)
    public void testStaticImportFailsWithJDK14() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTImportDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTImportDeclaration = new ASTImportDeclaration[0].getClass().getComponentType();
        }
        this.getNodes(clazz, TEST3);
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ast$ASTImportDeclarationTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ast$ASTImportDeclarationTest = new ASTImportDeclarationTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

