/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.TargetJDK1_5;
import net.sourceforge.pmd.TargetJDKVersion;
import net.sourceforge.pmd.ast.ASTAnnotation;
import net.sourceforge.pmd.ast.ParseException;
import org.junit.Ignore;
import test.net.sourceforge.pmd.testframework.ParserTst;

public class ASTAnnotationTest
extends ParserTst {
    private static final String TEST1 = "public class Foo extends Buz {" + PMD.EOL + " @Override" + PMD.EOL + " void bar() {" + PMD.EOL + "  // overrides a superclass method" + PMD.EOL + " }" + PMD.EOL + "}";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAnnotation;
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ast$ASTAnnotationTest;

    @Ignore(value="// FIXME fail(\"Should have failed to parse an annotation in JDK 1.4 mode\");")
    @org.junit.Test(expected=ParseException.class)
    public void testAnnotationFailsWithJDK14() throws Throwable {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTAnnotation;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTAnnotation = new ASTAnnotation[0].getClass().getComponentType();
        }
        this.getNodes(clazz, TEST1);
    }

    @Ignore(value="// FIXME fail(\"Should have failed to parse an annotation in JDK 1.5 mode\");")
    @org.junit.Test(expected=ParseException.class)
    public void testAnnotationSucceedsWithJDK15() throws Throwable {
        TargetJDK1_5 targetJDK1_5 = new TargetJDK1_5();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTAnnotation;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTAnnotation = new ASTAnnotation[0].getClass().getComponentType();
        }
        this.getNodes((TargetJDKVersion)targetJDK1_5, clazz, TEST1);
    }

    public static Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ast$ASTAnnotationTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ast$ASTAnnotationTest = new ASTAnnotationTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }
}

