/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import java.util.Iterator;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.stat.Metric;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.SourceFileScope;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.junit.Assert;
import org.junit.Test;
import test.net.sourceforge.pmd.testframework.MockRule;
import test.net.sourceforge.pmd.testframework.RuleTst;

public class ReportTest
extends RuleTst
implements ReportListener {
    private boolean violationSemaphore;
    private boolean metricSemaphore;
    private static final String TEST1 = "public class Foo {}" + PMD.EOL;
    private static final String TEST2 = "@SuppressWarnings(\"PMD\")" + PMD.EOL + "public class Foo {}";
    private static final String TEST3 = "public class Foo {} // NOPMD";
    private static final /* synthetic */ Class class$test$net$sourceforge$pmd$ReportTest;

    public void ruleViolationAdded(IRuleViolation ruleViolation) {
        this.violationSemaphore = true;
    }

    public void metricAdded(Metric metric) {
        this.metricSemaphore = true;
    }

    @Test
    public void testBasic() throws Throwable {
        Report r = new Report();
        this.runTestFromString(TEST1, (Rule)new FooRule(), r);
        Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testMetric0() {
        Report r = new Report();
        Assert.assertTrue((String)"Default report shouldn't contain metrics", (!r.hasMetrics() ? 1 : 0) != 0);
    }

    @Test
    public void testMetric1() {
        Report r = new Report();
        Assert.assertTrue((String)"Default report shouldn't contain metrics", (!r.hasMetrics() ? 1 : 0) != 0);
        r.addMetric(new Metric("m1", 0, 0.0, 1.0, 2.0, 3.0, 4.0));
        Assert.assertTrue((String)"Expected metrics weren't there", (boolean)r.hasMetrics());
        Iterator ms = r.metrics();
        Assert.assertTrue((String)"Should have some metrics in there now", (boolean)ms.hasNext());
        Object o = ms.next();
        Assert.assertTrue((String)("Expected Metric, got " + o.getClass()), (boolean)(o instanceof Metric));
        Metric m = (Metric)o;
        Assert.assertEquals((String)"metric name mismatch", (Object)"m1", (Object)m.getMetricName());
        Assert.assertEquals((String)"wrong low value", (double)1.0, (double)m.getLowValue(), (double)0.05);
        Assert.assertEquals((String)"wrong high value", (double)2.0, (double)m.getHighValue(), (double)0.05);
        Assert.assertEquals((String)"wrong avg value", (double)3.0, (double)m.getAverage(), (double)0.05);
        Assert.assertEquals((String)"wrong std dev value", (double)4.0, (double)m.getStandardDeviation(), (double)0.05);
    }

    @Test
    public void testExclusionsInReportWithAnnotations() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST2, (Rule)new FooRule(), rpt, SourceType.JAVA_15);
        Assert.assertTrue((boolean)rpt.isEmpty());
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rpt.getSuppressedRuleViolations().size()));
    }

    @Test
    public void testExclusionsInReportWithNOPMD() throws Throwable {
        Report rpt = new Report();
        this.runTestFromString(TEST3, (Rule)new FooRule(), rpt);
        Assert.assertTrue((boolean)rpt.isEmpty());
        Assert.assertEquals((Object)Integer_.valueOf((int)1), (Object)Integer_.valueOf((int)rpt.getSuppressedRuleViolations().size()));
    }

    @Test
    public void testSortedReport_File() {
        Report r = new Report();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("foo");
        SimpleNode s = this.getNode(10, 5, ctx.getSourceCodeFilename());
        r.addRuleViolation((IRuleViolation)new RuleViolation((Rule)new MockRule("name", "desc", "msg", "rulesetname"), ctx, s));
        ctx.setSourceCodeFilename("bar");
        SimpleNode s1 = this.getNode(10, 5, ctx.getSourceCodeFilename());
        r.addRuleViolation((IRuleViolation)new RuleViolation((Rule)new MockRule("name", "desc", "msg", "rulesetname"), ctx, s1));
        XMLRenderer rend = new XMLRenderer();
        String result = rend.render(r);
        Assert.assertTrue((String)"sort order wrong", (result.indexOf("bar") < result.indexOf("foo") ? 1 : 0) != 0);
    }

    @Test
    public void testSortedReport_Line() {
        Report r = new Report();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("foo1");
        SimpleNode s = this.getNode(10, 5, ctx.getSourceCodeFilename());
        r.addRuleViolation((IRuleViolation)new RuleViolation((Rule)new MockRule("rule2", "rule2", "msg", "rulesetname"), ctx, s));
        ctx.setSourceCodeFilename("foo2");
        SimpleNode s1 = this.getNode(20, 5, ctx.getSourceCodeFilename());
        r.addRuleViolation((IRuleViolation)new RuleViolation((Rule)new MockRule("rule1", "rule1", "msg", "rulesetname"), ctx, s1));
        XMLRenderer rend = new XMLRenderer();
        String result = rend.render(r);
        Assert.assertTrue((String)"sort order wrong", (result.indexOf("rule2") < result.indexOf("rule1") ? 1 : 0) != 0);
    }

    @Test
    public void testListener() {
        Report rpt = new Report();
        rpt.addListener((ReportListener)this);
        this.violationSemaphore = false;
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("file");
        SimpleNode s = this.getNode(5, 5, ctx.getSourceCodeFilename());
        rpt.addRuleViolation((IRuleViolation)new RuleViolation((Rule)new MockRule("name", "desc", "msg", "rulesetname"), ctx, s));
        Assert.assertTrue((boolean)this.violationSemaphore);
        this.metricSemaphore = false;
        rpt.addMetric(new Metric("test", 0, 0.0, 0.0, 0.0, 0.0, 0.0));
        Assert.assertTrue((String)"no metric", (boolean)this.metricSemaphore);
    }

    @Test
    public void testSummary() {
        Report r = new Report();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("foo1");
        SimpleNode s = this.getNode(5, 5, ctx.getSourceCodeFilename());
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        r.addRuleViolation((IRuleViolation)new RuleViolation((Rule)rule, ctx, s));
        ctx.setSourceCodeFilename("foo2");
        MockRule mr = new MockRule("rule1", "rule1", "msg", "rulesetname");
        SimpleNode s1 = this.getNode(20, 5, ctx.getSourceCodeFilename());
        SimpleNode s2 = this.getNode(30, 5, ctx.getSourceCodeFilename());
        r.addRuleViolation((IRuleViolation)new RuleViolation((Rule)mr, ctx, s1));
        r.addRuleViolation((IRuleViolation)new RuleViolation((Rule)mr, ctx, s2));
        Map summary = r.getSummary();
        Assert.assertEquals((Object)Integer_.valueOf((int)summary.keySet().size()), (Object)Integer_.valueOf((int)2));
        Assert.assertTrue((boolean)summary.values().contains(new Integer(1)));
        Assert.assertTrue((boolean)summary.values().contains(new Integer(2)));
    }

    private SimpleNode getNode(int line, int column, String scopeName) {
        SimpleJavaNode s = new SimpleJavaNode(2);
        SimpleJavaNode parent = new SimpleJavaNode(1);
        parent.testingOnly__setBeginLine(line);
        parent.testingOnly__setBeginColumn(column);
        s.jjtSetParent((Node)parent);
        s.setScope((Scope)new SourceFileScope(scopeName));
        s.testingOnly__setBeginLine(10);
        s.testingOnly__setBeginColumn(5);
        return s;
    }

    public static junit.framework.Test suite() {
        Class<?> clazz = class$test$net$sourceforge$pmd$ReportTest;
        if (clazz == null) {
            clazz = class$test$net$sourceforge$pmd$ReportTest = new ReportTest[0].getClass().getComponentType();
        }
        return new JUnit4TestAdapter((Class)clazz);
    }

    private static class FooRule
    extends AbstractRule {
        private FooRule() {
        }

        public Object visit(ASTClassOrInterfaceDeclaration c, Object ctx) {
            if ("Foo".equals(c.getImage())) {
                this.addViolation(ctx, (SimpleNode)c);
            }
            return ctx;
        }

        public String getMessage() {
            return "blah";
        }

        public String getName() {
            return "Foo";
        }

        public String getRuleSetName() {
            return "RuleSet";
        }

        public String getDescription() {
            return "desc";
        }
    }
}

