/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.CategoryFilteringBugReporter;
import edu.umd.cs.findbugs.ClassScreener;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.EmacsBugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsCommandLine;
import edu.umd.cs.findbugs.HTMLBugReporter;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PrintingBugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortingBugReporter;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.XDocsBugReporter;
import edu.umd.cs.findbugs.XMLBugReporter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class TextUICommandLine
extends FindBugsCommandLine {
    private static final int PRINTING_REPORTER = 0;
    private static final int SORTING_REPORTER = 1;
    private static final int XML_REPORTER = 2;
    private static final int EMACS_REPORTER = 3;
    private static final int HTML_REPORTER = 4;
    private static final int XDOCS_REPORTER = 5;
    private int bugReporterType = 0;
    private boolean relaxedReportingMode = false;
    private boolean useLongBugCodes = false;
    private boolean xmlWithMessages = false;
    private boolean xmlWithAbridgedMessages = false;
    private String stylesheet = null;
    private boolean quiet = false;
    private ClassScreener classScreener = new ClassScreener();
    private String includeFilterFile = null;
    private String excludeFilterFile = null;
    private boolean setExitCode = false;
    private int priorityThreshold = 2;
    private PrintStream outputStream = null;
    private Set<String> bugCategorySet = null;
    private UserPreferences userPreferences;
    private String trainingOutputDir;
    private String trainingInputDir;
    private String releaseName = "";
    private String projectName = "";
    private String sourceInfoFile = null;
    private boolean xargs = false;
    private boolean scanNestedArchives = false;

    public TextUICommandLine() {
        this.addSwitch("-showPlugins", "show list of available plugins");
        this.addSwitch("-timestampNow", "set timestamp of results to be current time");
        this.addSwitch("-quiet", "suppress error messages");
        this.addSwitch("-longBugCodes", "report long bug codes");
        this.addOption("-release", "release name", "set the release name of the analyzed application");
        this.addSwitch("-experimental", "report all warnings including experimental bug patterns");
        this.addSwitch("-low", "report all warnings");
        this.addSwitch("-medium", "report only medium and high priority warnings [default]");
        this.addSwitch("-high", "report only high priority warnings");
        this.addSwitch("-sortByClass", "sort warnings by class");
        this.addSwitchWithOptionalExtraPart("-xml", "withMessages", "XML output (optionally with messages)");
        this.addSwitch("-xdocs", "xdoc XML output to use with Apache Maven");
        this.addSwitchWithOptionalExtraPart("-html", "stylesheet", "Generate HTML output (default stylesheet is default.xsl)");
        this.addSwitch("-emacs", "Use emacs reporting format");
        this.addSwitch("-relaxed", "Relaxed reporting mode (more false positives!)");
        this.addSwitchWithOptionalExtraPart("-train", "outputDir", "Save training data (experimental); output dir defaults to '.'");
        this.addSwitchWithOptionalExtraPart("-useTraining", "inputDir", "Use training data (experimental); input dir defaults to '.'");
        this.addOption("-sourceInfo", "filename", "Specify source info file (line numbers for fields/classes)");
        this.addOption("-projectName", "project name", "Descriptive name of project");
        this.addOption("-outputFile", "filename", "Save output in named file");
        this.addOption("-visitors", "v1[,v2...]", "run only named visitors");
        this.addOption("-omitVisitors", "v1[,v2...]", "omit named visitors");
        this.addOption("-chooseVisitors", "+v1,-v2,...", "selectively enable/disable detectors");
        this.addOption("-choosePlugins", "+p1,-p2,...", "selectively enable/disable plugins");
        this.addOption("-adjustPriority", "v1=(raise|lower)[,...]", "raise/lower priority of warnings for given visitor(s)");
        this.addOption("-bugCategories", "cat1[,cat2...]", "only report bugs in given categories");
        this.addOption("-onlyAnalyze", "classes/packages", "only analyze given classes and packages");
        this.addOption("-exclude", "filter file", "exclude bugs matching given filter");
        this.addOption("-include", "filter file", "include only bugs matching given filter");
        this.addSwitchWithOptionalExtraPart("-nested", "true|false", "analyze nested jar/zip archives (default=true)");
        this.addOption("-auxclasspath", "classpath", "set aux classpath for analysis");
        this.addOption("-sourcepath", "source path", "set source path for analyzed classes");
        this.addSwitch("-exitcode", "set exit code of process");
        this.addSwitch("-xargs", "get list of classfiles/jarfiles from standard input rather than command line");
    }

    public Project getProject() {
        return this.project;
    }

    public boolean getXargs() {
        return this.xargs;
    }

    public boolean setExitCode() {
        return this.setExitCode;
    }

    public boolean quiet() {
        return this.quiet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressWarnings(value={"DM_EXIT"})
    protected void handleOption(String option, String optionExtraPart) {
        if (option.equals("-showPlugins")) {
            System.out.println("Available plugins:");
            int count = 0;
            Iterator<Plugin> i = DetectorFactoryCollection.instance().pluginIterator();
            while (i.hasNext()) {
                Plugin plugin = i.next();
                System.out.println("  " + plugin.getPluginId() + " (default: " + (plugin.isEnabled() ? "enabled" : "disabled") + ")");
                if (plugin.getShortDescription() != null) {
                    System.out.println("    Description: " + plugin.getShortDescription());
                }
                if (plugin.getProvider() != null) {
                    System.out.println("    Provider: " + plugin.getProvider());
                }
                if (plugin.getWebsite() != null) {
                    System.out.println("    Website: " + plugin.getWebsite());
                }
                ++count;
            }
            if (count == 0) {
                System.out.println("  No plugins are available (FindBugs installed incorrectly?)");
            }
            System.exit(0);
            return;
        } else if (option.equals("-experimental")) {
            this.priorityThreshold = 4;
            return;
        } else if (option.equals("-longBugCodes")) {
            this.useLongBugCodes = true;
            return;
        } else if (option.equals("-timestampNow")) {
            this.project.setTimestamp(System.currentTimeMillis());
            return;
        } else if (option.equals("-low")) {
            this.priorityThreshold = 3;
            return;
        } else if (option.equals("-medium")) {
            this.priorityThreshold = 2;
            return;
        } else if (option.equals("-high")) {
            this.priorityThreshold = 1;
            return;
        } else if (option.equals("-sortByClass")) {
            this.bugReporterType = 1;
            return;
        } else if (option.equals("-xml")) {
            this.bugReporterType = 2;
            if (optionExtraPart.equals("")) return;
            if (optionExtraPart.equals("withMessages")) {
                this.xmlWithMessages = true;
                return;
            } else {
                if (!optionExtraPart.equals("withAbridgedMessages")) throw new IllegalArgumentException("Unknown option: -xml:" + optionExtraPart);
                this.xmlWithMessages = true;
                this.xmlWithAbridgedMessages = true;
            }
            return;
        } else if (option.equals("-emacs")) {
            this.bugReporterType = 3;
            return;
        } else if (option.equals("-relaxed")) {
            this.relaxedReportingMode = true;
            return;
        } else if (option.equals("-train")) {
            this.trainingOutputDir = !optionExtraPart.equals("") ? optionExtraPart : ".";
            return;
        } else if (option.equals("-useTraining")) {
            this.trainingInputDir = !optionExtraPart.equals("") ? optionExtraPart : ".";
            return;
        } else if (option.equals("-html")) {
            this.bugReporterType = 4;
            this.stylesheet = !optionExtraPart.equals("") ? optionExtraPart : "default.xsl";
            return;
        } else if (option.equals("-xdocs")) {
            this.bugReporterType = 5;
            return;
        } else if (option.equals("-quiet")) {
            this.quiet = true;
            return;
        } else if (option.equals("-nested")) {
            this.scanNestedArchives = optionExtraPart.equals("") || Boolean.valueOf(optionExtraPart) != false;
            return;
        } else if (option.equals("-exitcode")) {
            this.setExitCode = true;
            return;
        } else if (option.equals("-xargs")) {
            this.xargs = true;
            return;
        } else {
            super.handleOption(option, optionExtraPart);
        }
    }

    @SuppressWarnings(value={"DM_EXIT"})
    protected void handleOptionWithArgument(String option, String argument) throws IOException {
        if (option.equals("-outputFile") || option.equals("-output")) {
            File outputFile = new File(argument);
            String extension = Util.getFileExtension(outputFile);
            if (this.bugReporterType == 0 && (extension.equals("xml") || extension.equals("fba"))) {
                this.bugReporterType = 2;
            }
            try {
                this.outputStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            }
            catch (IOException e) {
                System.err.println("Couldn't open " + outputFile + " for output: " + e.toString());
                System.exit(1);
            }
        } else if (option.equals("-projectName")) {
            this.projectName = argument;
        } else if (option.equals("-release")) {
            this.releaseName = argument;
        } else if (option.equals("-sourceInfo")) {
            this.sourceInfoFile = argument;
        } else if (option.equals("-visitors") || option.equals("-omitVisitors")) {
            boolean omit = option.equals("-omitVisitors");
            if (!omit) {
                this.getUserPreferences().enableAllDetectors(false);
            }
            StringTokenizer tok = new StringTokenizer(argument, ",");
            while (tok.hasMoreTokens()) {
                String visitorName = tok.nextToken();
                DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(visitorName);
                if (factory == null) {
                    throw new IllegalArgumentException("Unknown detector: " + visitorName);
                }
                this.getUserPreferences().enableDetector(factory, !omit);
            }
        } else if (option.equals("-chooseVisitors")) {
            this.choose(argument, "Detector choices", new Chooser(){

                public void choose(boolean enabled, String what) {
                    DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(what);
                    if (factory == null) {
                        throw new IllegalArgumentException("Unknown detector: " + what);
                    }
                    if (FindBugs.DEBUG) {
                        System.err.println("Detector " + factory.getShortName() + " " + (enabled ? "enabled" : "disabled") + ", userPreferences=" + System.identityHashCode(TextUICommandLine.this.getUserPreferences()));
                    }
                    TextUICommandLine.this.getUserPreferences().enableDetector(factory, enabled);
                }
            });
        } else if (option.equals("-choosePlugins")) {
            this.choose(argument, "Plugin choices", new Chooser(){

                public void choose(boolean enabled, String what) {
                    Plugin plugin = DetectorFactoryCollection.instance().getPluginById(what);
                    if (plugin == null) {
                        throw new IllegalArgumentException("Unknown plugin: " + what);
                    }
                    plugin.setEnabled(enabled);
                }
            });
        } else if (option.equals("-adjustPriority")) {
            StringTokenizer tok = new StringTokenizer(argument, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int eq = token.indexOf(61);
                if (eq < 0) {
                    throw new IllegalArgumentException("Illegal priority adjustment: " + token);
                }
                String visitorName = token.substring(0, eq);
                DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(visitorName);
                if (factory == null) {
                    throw new IllegalArgumentException("Unknown detector: " + visitorName);
                }
                String adjustment = token.substring(eq + 1);
                if (!adjustment.equals("raise") && !adjustment.equals("lower")) {
                    throw new IllegalArgumentException("Illegal priority adjustment value: " + adjustment);
                }
                factory.setPriorityAdjustment(adjustment.equals("raise") ? -1 : 1);
            }
        } else if (option.equals("-bugCategories")) {
            this.bugCategorySet = FindBugs.handleBugCategories(this.getUserPreferences(), argument);
        } else if (option.equals("-onlyAnalyze")) {
            StringTokenizer tok = new StringTokenizer(argument, ",");
            while (tok.hasMoreTokens()) {
                String item = tok.nextToken();
                if (item.endsWith(".-")) {
                    this.classScreener.addAllowedPrefix(item.substring(0, item.length() - 1));
                    continue;
                }
                if (item.endsWith(".*")) {
                    this.classScreener.addAllowedPackage(item.substring(0, item.length() - 1));
                    continue;
                }
                this.classScreener.addAllowedClass(item);
            }
        } else if (option.equals("-exclude")) {
            if (this.excludeFilterFile != null) {
                throw new IllegalArgumentException("Can specify one exclude filter file");
            }
            this.excludeFilterFile = argument;
        } else if (option.equals("-include")) {
            if (this.includeFilterFile != null) {
                throw new IllegalArgumentException("Can specify one include filter file");
            }
            this.includeFilterFile = argument;
        } else if (option.equals("-auxclasspath")) {
            StringTokenizer tok = new StringTokenizer(argument, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                this.project.addAuxClasspathEntry(tok.nextToken());
            }
        } else if (option.equals("-sourcepath")) {
            StringTokenizer tok = new StringTokenizer(argument, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                this.project.addSourceDir(new File(tok.nextToken()).getAbsolutePath());
            }
        } else {
            super.handleOptionWithArgument(option, argument);
        }
    }

    private void choose(String argument, String desc, Chooser chooser) {
        StringTokenizer tok = new StringTokenizer(argument, ",");
        while (tok.hasMoreTokens()) {
            String what = tok.nextToken();
            if (!what.startsWith("+") && !what.startsWith("-")) {
                throw new IllegalArgumentException(desc + " must start with " + "\"+\" or \"-\" (saw " + what + ")");
            }
            boolean enabled = what.startsWith("+");
            chooser.choose(enabled, what.substring(1));
        }
    }

    public void configureEngine(IFindBugsEngine findBugs) throws IOException, FilterException {
        TextUIBugReporter textuiBugReporter;
        DetectorFactoryCollection.instance().ensureLoaded();
        findBugs.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        switch (this.bugReporterType) {
            case 0: {
                textuiBugReporter = new PrintingBugReporter();
                break;
            }
            case 1: {
                textuiBugReporter = new SortingBugReporter();
                break;
            }
            case 2: {
                XMLBugReporter xmlBugReporter = new XMLBugReporter(this.project);
                xmlBugReporter.setAddMessages(this.xmlWithMessages);
                textuiBugReporter = xmlBugReporter;
                break;
            }
            case 3: {
                textuiBugReporter = new EmacsBugReporter();
                break;
            }
            case 4: {
                textuiBugReporter = new HTMLBugReporter(this.project, this.stylesheet);
                break;
            }
            case 5: {
                textuiBugReporter = new XDocsBugReporter(this.project);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.quiet) {
            textuiBugReporter.setErrorVerbosity(0);
        }
        textuiBugReporter.setPriorityThreshold(this.priorityThreshold);
        textuiBugReporter.setUseLongBugCodes(this.useLongBugCodes);
        if (this.outputStream != null) {
            textuiBugReporter.setOutputStream(this.outputStream);
        }
        BugReporter bugReporter = textuiBugReporter;
        if (this.bugCategorySet != null) {
            bugReporter = new CategoryFilteringBugReporter(bugReporter, this.bugCategorySet);
        }
        findBugs.setBugReporter(bugReporter);
        findBugs.setProject(this.project);
        findBugs.setUserPreferences(this.getUserPreferences());
        if (this.includeFilterFile != null) {
            findBugs.addFilter(this.includeFilterFile, true);
        }
        if (this.excludeFilterFile != null) {
            findBugs.addFilter(this.excludeFilterFile, false);
        }
        findBugs.setClassScreener(this.classScreener);
        findBugs.setRelaxedReportingMode(this.relaxedReportingMode);
        findBugs.setAbridgedMessages(this.xmlWithAbridgedMessages);
        if (this.trainingOutputDir != null) {
            findBugs.enableTrainingOutput(this.trainingOutputDir);
        }
        if (this.trainingInputDir != null) {
            findBugs.enableTrainingInput(this.trainingInputDir);
        }
        if (this.sourceInfoFile != null) {
            findBugs.setSourceInfoFile(this.sourceInfoFile);
        }
        findBugs.setAnalysisFeatureSettings(this.settingList);
        findBugs.setReleaseName(this.releaseName);
        findBugs.setProjectName(this.projectName);
        findBugs.setScanNestedArchives(this.scanNestedArchives);
    }

    public void handleXArgs() throws IOException {
        if (this.getXargs()) {
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((s = in.readLine()) != null) {
                this.project.addFile(s);
            }
        }
    }

    private void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
    }

    private UserPreferences getUserPreferences() {
        if (this.userPreferences == null) {
            this.userPreferences = UserPreferences.createDefaultUserPreferences();
        }
        return this.userPreferences;
    }

    private static interface Chooser {
        public void choose(boolean var1, String var2);
    }
}

