/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.header.AbstractHeaderCheck;
import com.puppycrawl.tools.checkstyle.checks.header.HeaderInfo;
import java.util.Arrays;

public class HeaderCheck
extends AbstractHeaderCheck {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] mIgnoreLines = EMPTY_INT_ARRAY;

    private boolean isIgnoreLine(int aLineNo) {
        return Arrays.binarySearch(this.mIgnoreLines, aLineNo) >= 0;
    }

    protected boolean isMatch(int aLineNumber) {
        String line = this.getLines()[aLineNumber];
        return this.isIgnoreLine(aLineNumber + 1) || this.getHeaderLines()[aLineNumber].equals(line);
    }

    public void setIgnoreLines(int[] aList) {
        if (aList == null || aList.length == 0) {
            this.mIgnoreLines = EMPTY_INT_ARRAY;
            return;
        }
        this.mIgnoreLines = new int[aList.length];
        System.arraycopy(aList, 0, this.mIgnoreLines, 0, aList.length);
        Arrays.sort(this.mIgnoreLines);
    }

    public void beginTree(DetailAST aRootAST) {
        if (this.getHeaderLines().length > this.getLines().length) {
            this.log(1, "header.missing");
        } else {
            for (int i = 0; i < this.getHeaderLines().length; ++i) {
                if (this.isMatch(i)) continue;
                this.log(i + 1, "header.mismatch", (Object)this.getHeaderLines()[i]);
                break;
            }
        }
    }

    protected HeaderInfo createHeaderInfo() {
        return new HeaderInfo();
    }
}

