/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassResolver {
    private static final Log LOG = LogFactory.getLog(ClassResolver.class);
    private final String mPkg;
    private final Set mImports;
    private final ClassLoader mLoader;

    public ClassResolver(ClassLoader aLoader, String aPkg, Set aImports) {
        this.mLoader = aLoader;
        this.mPkg = aPkg;
        this.mImports = aImports;
        this.mImports.add("java.lang.*");
    }

    public Class resolve(String aName, String aCurrentClass) throws ClassNotFoundException {
        String innerClass;
        String imp;
        Class clazz = this.resolveQualifiedName(aName);
        if (clazz != null) {
            return clazz;
        }
        Iterator it = this.mImports.iterator();
        while (it.hasNext()) {
            imp = (String)it.next();
            if (!imp.endsWith("." + aName) || (clazz = this.resolveQualifiedName(imp)) == null) continue;
            return clazz;
        }
        if (!"".equals(this.mPkg) && (clazz = this.resolveQualifiedName(this.mPkg + "." + aName)) != null) {
            return clazz;
        }
        if (!"".equals(aCurrentClass) && this.isLoadable(innerClass = (!"".equals(this.mPkg) ? this.mPkg + "." : "") + aCurrentClass + "$" + aName)) {
            return this.safeLoad(innerClass);
        }
        it = this.mImports.iterator();
        while (it.hasNext()) {
            String fqn;
            imp = (String)it.next();
            if (!imp.endsWith(".*") || (clazz = this.resolveQualifiedName(fqn = imp.substring(0, imp.lastIndexOf(46) + 1) + aName)) == null) continue;
            return clazz;
        }
        return this.safeLoad(aName);
    }

    public boolean isLoadable(String aName) {
        try {
            this.safeLoad(aName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Class safeLoad(String aName) throws ClassNotFoundException {
        LOG.debug(aName);
        return Class.forName(aName, false, this.mLoader);
    }

    private Class resolveQualifiedName(String aName) {
        try {
            String innerName;
            if (this.isLoadable(aName)) {
                return this.safeLoad(aName);
            }
            int dot = aName.lastIndexOf(".");
            if (dot != -1 && this.isLoadable(innerName = aName.substring(0, dot) + "$" + aName.substring(dot + 1))) {
                return this.safeLoad(innerName);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }
}

