/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.SCRUtil;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.util.io.Externalizable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentInstance;

public class ComponentReference
implements Externalizable {
    public static final int CARDINALITY_0_1 = 0;
    public static final int CARDINALITY_0_N = 1;
    public static final int CARDINALITY_1_1 = 2;
    public static final int CARDINALITY_1_N = 3;
    public static final int POLICY_STATIC = 0;
    public static final int POLICY_DYNAMIC = 1;
    public String name;
    public String interfaceName;
    public int cardinality = 2;
    public int policy = 0;
    public String target;
    public String bind;
    public String unbind;
    ServiceComponent component;
    private boolean bindCached;
    private boolean unbindCached;
    private Method bindMethod;
    private Method unbindMethod;
    public Hashtable serviceReferences = new Hashtable(3);
    private Hashtable serviceReferencesToUnbind = new Hashtable(3);
    static final Class[] SERVICE_REFERENCE;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.ServiceReference");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        SERVICE_REFERENCE = classArray;
    }

    ComponentReference(ServiceComponent component) {
        this.component = component;
        if (this.component.references == null) {
            this.component.references = new Vector(2);
        }
        this.component.references.addElement(this);
    }

    Method getMethod(ComponentInstanceImpl componentInstance, Reference reference, String methodName, ServiceReference serviceReference) {
        Class<?> consumerClass = componentInstance.getInstance().getClass();
        Object serviceObject = null;
        Class<?> serviceObjectClass = null;
        Class<?> interfaceClass = null;
        Class[] param_interfaceClass = null;
        Method method = null;
        while (consumerClass != null) {
            try {
                method = consumerClass.getDeclaredMethod(methodName, SERVICE_REFERENCE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoClassDefFoundError err) {
                this.logWarning("[SCR] Exception occurred while getting method '" + methodName + "' of class " + consumerClass.getName(), err, reference);
            }
            if (method != null) break;
            if (serviceObject == null) {
                serviceObject = componentInstance.bindedServices.get(serviceReference);
                if (serviceObject == null) {
                    serviceObject = InstanceProcess.staticRef.getService(reference, serviceReference);
                }
                if (serviceObject == null) {
                    return null;
                }
                componentInstance.bindedServices.put(serviceReference, serviceObject);
                Class<?> searchForInterfaceClass = serviceObjectClass = serviceObject.getClass();
                while (searchForInterfaceClass != null) {
                    Class<?>[] interfaceClasses = searchForInterfaceClass.getInterfaces();
                    int i = 0;
                    while (i < interfaceClasses.length) {
                        if (interfaceClasses[i].getName().equals(this.interfaceName)) {
                            interfaceClass = interfaceClasses[i];
                            break;
                        }
                        ++i;
                    }
                    if (interfaceClass != null) break;
                    if (searchForInterfaceClass.getName().equals(this.interfaceName)) {
                        interfaceClass = searchForInterfaceClass;
                        break;
                    }
                    searchForInterfaceClass = searchForInterfaceClass.getSuperclass();
                }
                param_interfaceClass = new Class[]{interfaceClass};
            }
            try {
                method = consumerClass.getDeclaredMethod(methodName, param_interfaceClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoClassDefFoundError err) {
                this.logWarning("[SCR] Exception occurred while getting method '" + methodName + "' of class " + consumerClass.getName(), err, reference);
            }
            if (method != null) break;
            Method[] methods = consumerClass.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                Class<?>[] params = methods[i].getParameterTypes();
                if (params.length == 1 && methods[i].getName().equals(methodName) && params[0].isAssignableFrom(serviceObjectClass)) {
                    method = methods[i];
                    break;
                }
                ++i;
            }
            if (method != null) break;
            consumerClass = consumerClass.getSuperclass();
        }
        if (method == null) {
            this.logMethodNotFoundError(componentInstance, reference, methodName);
            return null;
        }
        int modifier = method.getModifiers();
        if (!Modifier.isProtected(modifier) && !Modifier.isPublic(modifier)) {
            this.logMethodNotVisible(componentInstance, reference, methodName, method.getParameterTypes()[0]);
            return null;
        }
        if (Modifier.isProtected(modifier)) {
            SCRUtil.setAccessible(method);
        }
        return method;
    }

    private void logMethodNotVisible(ComponentInstanceImpl componentInstance, Reference reference, String methodName, Class param_interfaceClass) {
        String param_interfaceName = param_interfaceClass.getName();
        StringBuffer buffer = this.createBuffer();
        buffer.append("[SCR] Method ");
        buffer.append(methodName);
        buffer.append('(');
        buffer.append(param_interfaceName);
        buffer.append(')');
        buffer.append(" is not protected or public!");
        this.appendDetails(buffer, reference);
        String message = buffer.toString();
        Activator.log.error(message, null);
    }

    private void logMethodNotFoundError(ComponentInstanceImpl componentInstance, Reference reference, String methodName) {
        StringBuffer buffer = this.createBuffer();
        buffer.append("[SCR] Method was not found: ");
        buffer.append(methodName);
        buffer.append('(');
        buffer.append(reference.reference.interfaceName);
        buffer.append(')');
        this.appendDetails(buffer, reference);
        String message = buffer.toString();
        Activator.log.error(message, null);
    }

    private void appendDetails(StringBuffer buffer, Reference reference) {
        try {
            String indent = "\n\t";
            buffer.append(indent);
            buffer.append("Details:");
            buffer.append(indent);
            buffer.append("Problematic reference = " + reference.reference);
            buffer.append(indent);
            buffer.append("of service component = ");
            buffer.append(reference.reference.component.name);
            buffer.append(indent);
            buffer.append("component implementation class = ");
            buffer.append(reference.reference.component.implementation);
            buffer.append(indent);
            buffer.append("located in bundle with symbolic name = ");
            buffer.append(this.component.bc.getBundle().getSymbolicName());
            buffer.append(indent);
            buffer.append("bundle location = ");
            buffer.append(this.component.bc.getBundle().getLocation());
        }
        catch (Throwable throwable) {}
    }

    private void logWarning(String message, Throwable t, Reference reference) {
        StringBuffer buffer = this.createBuffer();
        buffer.append(message);
        this.appendDetails(buffer, reference);
        Activator.log.warning(buffer.toString(), t);
    }

    private void logError(String message, Throwable t, Reference reference) {
        StringBuffer buffer = this.createBuffer();
        buffer.append(message);
        this.appendDetails(buffer, reference);
        Activator.log.error(buffer.toString(), t);
    }

    private StringBuffer createBuffer() {
        return new StringBuffer(400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void bind(Reference reference, ComponentInstance instance, ServiceReference serviceReference) throws Exception {
        if (this.bind != null) {
            Vector instances;
            boolean isComponentFactory = this.component.factory != null;
            Hashtable hashtable = this.serviceReferences;
            synchronized (hashtable) {
                if (isComponentFactory) {
                    instances = (Vector)this.serviceReferences.get(serviceReference);
                    if (instances == null) {
                        instances = new Vector(2);
                        instances.addElement(instance);
                        this.serviceReferences.put(serviceReference, instances);
                    } else {
                        if (instances.contains(instance)) {
                            if (reference.isUnary()) {
                                this.logWarning("[SCR] ComponentReference.bind(): service reference " + serviceReference + " is already bound to instance " + instance, null, reference);
                            }
                            return;
                        }
                        instances.addElement(instance);
                    }
                } else {
                    Object compInstance = this.serviceReferences.get(serviceReference);
                    if (compInstance == instance) {
                        if (reference.isUnary()) {
                            this.logWarning("[SCR] ComponentReference.bind(): service reference " + serviceReference + " is already bound to instance " + instance, null, reference);
                        }
                        return;
                    }
                    if (compInstance != null) {
                        this.logWarning("[SCR] ComponentReference.bind(): service reference " + serviceReference + " is already bound to another instance: " + compInstance, null, reference);
                        return;
                    }
                    this.serviceReferences.put(serviceReference, instance);
                }
            }
            if (!this.bindCached) {
                this.bindMethod = this.getMethod((ComponentInstanceImpl)instance, reference, this.bind, serviceReference);
                if (this.bindMethod != null) {
                    this.bindCached = true;
                }
            }
            if (this.bindMethod != null) {
                Object methodParam = null;
                Class<?> clazz = this.bindMethod.getParameterTypes()[0];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.osgi.framework.ServiceReference");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    methodParam = serviceReference;
                } else {
                    methodParam = ((ComponentInstanceImpl)instance).bindedServices.get(serviceReference);
                    if (methodParam == null && (methodParam = InstanceProcess.staticRef.getService(reference, serviceReference)) != null) {
                        ((ComponentInstanceImpl)instance).bindedServices.put(serviceReference, methodParam);
                    }
                    if (methodParam == null) {
                        if (isComponentFactory) {
                            instances = (Vector)this.serviceReferences.get(serviceReference);
                            instances.removeElement(instance);
                            if (instances.isEmpty()) {
                                this.serviceReferences.remove(serviceReference);
                            }
                        } else {
                            this.serviceReferences.remove(serviceReference);
                        }
                        return;
                    }
                }
                Object[] params = SCRUtil.getObjectArray();
                params[0] = methodParam;
                try {
                    try {
                        this.bindMethod.invoke(instance.getInstance(), params);
                    }
                    catch (Throwable t) {
                        this.logError("[SCR] Error while trying to bind reference " + this, t, reference);
                        SCRUtil.release(params);
                    }
                }
                finally {
                    SCRUtil.release(params);
                }
            } else {
                if (isComponentFactory) {
                    Vector instances2 = (Vector)this.serviceReferences.get(serviceReference);
                    instances2.removeElement(instance);
                    if (instances2.isEmpty()) {
                        this.serviceReferences.remove(serviceReference);
                    }
                } else {
                    this.serviceReferences.remove(serviceReference);
                }
                this.logWarning("[SCR] ComponentReference.bind(): bind method '" + this.bind + "' is not found or it is not accessible!", null, reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unbind(Reference reference, ComponentInstance instance, ServiceReference serviceReference) {
        boolean componentFactory;
        block53: {
            Object methodParam;
            block55: {
                Hashtable hashtable;
                boolean referenceExists = true;
                componentFactory = this.component.factory != null;
                Hashtable hashtable2 = this.serviceReferences;
                synchronized (hashtable2) {
                    Vector instances;
                    if (componentFactory) {
                        instances = (Vector)this.serviceReferences.get(serviceReference);
                        if (instances == null) {
                            referenceExists = false;
                        } else if (!instances.contains(instance)) {
                            this.logWarning("[SCR] ComponentReference.unbind(): component instance not bound! It is: " + instance, null, reference);
                            return;
                        }
                    } else {
                        Object compInstance = this.serviceReferences.get(serviceReference);
                        if (compInstance == null) {
                            referenceExists = false;
                        } else if (compInstance != instance) {
                            this.logWarning("[SCR] ComponentReference.unbind(): component instance not bound! It is: " + instance, null, reference);
                            return;
                        }
                    }
                    if (referenceExists) {
                        if (componentFactory) {
                            instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
                            if (instances != null && instances.contains(instance)) {
                                return;
                            }
                            if (instances == null) {
                                instances = new Vector(2);
                                this.serviceReferencesToUnbind.put(serviceReference, instances);
                            }
                            instances.addElement(instance);
                        } else {
                            if (this.serviceReferencesToUnbind.get(serviceReference) == instance) {
                                return;
                            }
                            this.serviceReferencesToUnbind.put(serviceReference, instance);
                        }
                    }
                }
                if (!referenceExists) {
                    this.logWarning("[SCR] ComponentReference.unbind(): invalid service reference " + serviceReference, null, reference);
                    return;
                }
                try {
                    if (this.unbind == null) break block53;
                    if (!this.unbindCached) {
                        this.unbindCached = true;
                        this.unbindMethod = this.getMethod((ComponentInstanceImpl)instance, reference, this.unbind, serviceReference);
                    }
                    if (this.unbindMethod == null) break block53;
                    methodParam = null;
                    Class<?> clazz = this.unbindMethod.getParameterTypes()[0];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.osgi.framework.ServiceReference");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(clazz2)) {
                        methodParam = serviceReference;
                        break block55;
                    }
                    methodParam = ((ComponentInstanceImpl)instance).bindedServices.get(serviceReference);
                    if (methodParam == null) {
                        methodParam = InstanceProcess.staticRef.getService(reference, serviceReference);
                    }
                    if (methodParam != null) break block55;
                    hashtable = this.serviceReferences;
                }
                catch (Throwable throwable) {
                    Hashtable hashtable3 = this.serviceReferences;
                    synchronized (hashtable3) {
                        if (componentFactory) {
                            Vector instances = (Vector)this.serviceReferences.get(serviceReference);
                            instances.removeElement(instance);
                            if (instances.isEmpty()) {
                                this.serviceReferences.remove(serviceReference);
                            }
                            instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
                            instances.removeElement(instance);
                            if (instances.isEmpty()) {
                                this.serviceReferencesToUnbind.remove(serviceReference);
                            }
                        } else {
                            this.serviceReferences.remove(serviceReference);
                            this.serviceReferencesToUnbind.remove(serviceReference);
                        }
                    }
                    throw throwable;
                }
                synchronized (hashtable) {
                    if (componentFactory) {
                        Vector instances = (Vector)this.serviceReferences.get(serviceReference);
                        instances.removeElement(instance);
                        if (instances.isEmpty()) {
                            this.serviceReferences.remove(serviceReference);
                        }
                        instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
                        instances.removeElement(instance);
                        if (instances.isEmpty()) {
                            this.serviceReferencesToUnbind.remove(serviceReference);
                        }
                    } else {
                        this.serviceReferences.remove(serviceReference);
                        this.serviceReferencesToUnbind.remove(serviceReference);
                    }
                }
                return;
            }
            Object[] params = SCRUtil.getObjectArray();
            params[0] = methodParam;
            try {
                try {
                    this.unbindMethod.invoke(instance.getInstance(), params);
                }
                catch (Throwable t) {
                    this.logError("[SCR] Exception occurred while unbinding reference " + this, t, reference);
                    SCRUtil.release(params);
                    break block53;
                }
            }
            catch (Throwable throwable) {
                SCRUtil.release(params);
                throw throwable;
            }
            SCRUtil.release(params);
        }
        Hashtable hashtable = this.serviceReferences;
        synchronized (hashtable) {
            if (componentFactory) {
                Vector instances = (Vector)this.serviceReferences.get(serviceReference);
                instances.removeElement(instance);
                if (instances.isEmpty()) {
                    this.serviceReferences.remove(serviceReference);
                }
                instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
                instances.removeElement(instance);
                if (instances.isEmpty()) {
                    this.serviceReferencesToUnbind.remove(serviceReference);
                }
            } else {
                this.serviceReferences.remove(serviceReference);
                this.serviceReferencesToUnbind.remove(serviceReference);
            }
        }
        if (((ComponentInstanceImpl)instance).bindedServices.remove(serviceReference) != null) {
            this.component.bc.ungetService(serviceReference);
        }
    }

    public final void dispose() {
        this.unbindCached = false;
        this.bindCached = false;
        this.unbindMethod = null;
        this.bindMethod = null;
        this.serviceReferences = null;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Reference[");
        buffer.append("name = ").append(this.name);
        buffer.append(", interface = ").append(this.interfaceName);
        buffer.append(", policy = ");
        switch (this.policy) {
            case 1: {
                buffer.append("dynamic");
                break;
            }
            case 0: {
                buffer.append("static");
            }
        }
        buffer.append(", cardinality = ");
        switch (this.cardinality) {
            case 0: {
                buffer.append("0..1");
                break;
            }
            case 1: {
                buffer.append("0..n");
                break;
            }
            case 2: {
                buffer.append("1..1");
                break;
            }
            case 3: {
                buffer.append("1..n");
            }
        }
        buffer.append(", target = ").append(this.target);
        buffer.append(", bind = ").append(this.bind);
        buffer.append(", unbind = ").append(this.unbind);
        buffer.append("]");
        return buffer.toString();
    }

    public synchronized void writeObject(OutputStream o) throws Exception {
        try {
            DataOutputStream out = o instanceof DataOutputStream ? (DataOutputStream)o : new DataOutputStream(o);
            out.writeUTF(this.name);
            out.writeUTF(this.interfaceName);
            out.writeInt(this.cardinality);
            out.writeInt(this.policy);
            boolean flag = this.target != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.target);
            }
            flag = this.bind != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.bind);
            }
            flag = this.unbind != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.unbind);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void readObject(InputStream s) throws Exception {
        try {
            DataInputStream in = s instanceof DataInputStream ? (DataInputStream)s : new DataInputStream(s);
            this.name = in.readUTF();
            this.interfaceName = in.readUTF();
            this.cardinality = in.readInt();
            this.policy = in.readInt();
            boolean flag = in.readBoolean();
            if (flag) {
                this.target = in.readUTF();
            }
            if (flag = in.readBoolean()) {
                this.bind = in.readUTF();
            }
            if (flag = in.readBoolean()) {
                this.unbind = in.readUTF();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

