/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collection;
import java.util.Iterator;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ObjectType;

public class StaticCalendarDetector
extends OpcodeStackDetector {
    private static final boolean DEBUG = Boolean.getBoolean("debug.staticcal");
    private static final String PROP_SKIP_SYNCHRONIZED_CHECK = "staticcal.skipsynccheck";
    private BugReporter reporter;
    private String currentClass;
    private final ObjectType calendarType = ObjectTypeFactory.getInstance((String)"java.util.Calendar");
    private final ObjectType dateFormatType = ObjectTypeFactory.getInstance((String)"java.text.DateFormat");
    private Method currentMethod = null;
    private CFG currentCFG;
    private LockDataflow currentLockDataFlow;

    public StaticCalendarDetector(BugReporter aReporter) {
        this.reporter = aReporter;
    }

    public void visit(JavaClass someObj) {
        this.currentClass = someObj.getClassName();
        this.currentMethod = null;
        this.currentCFG = null;
        this.currentLockDataFlow = null;
        super.visit(someObj);
    }

    public void visit(Field aField) {
        super.visit(aField);
        String tFieldSig = aField.getSignature();
        if (aField.getType() instanceof ObjectType) {
            String tBugType = null;
            ObjectType tType = (ObjectType)aField.getType();
            try {
                if (tType.subclassOf(this.calendarType) && aField.isStatic()) {
                    tBugType = "STCAL_STATIC_CALENDAR_INSTANCE";
                } else if (tType.subclassOf(this.dateFormatType) && aField.isStatic()) {
                    tBugType = "STCAL_STATIC_SIMPLE_DATA_FORMAT_INSTANCE";
                }
                if (tBugType != null) {
                    this.reporter.reportBug(new BugInstance((Detector)this, tBugType, aField.isPublic() ? 1 : 2).addClass(this.currentClass).addField(this.currentClass, aField.getName(), tFieldSig, true));
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass((ClassNotFoundException)e);
            }
        }
    }

    public void visitMethod(Method obj) {
        try {
            super.visitMethod(obj);
            this.currentMethod = obj;
            this.currentLockDataFlow = this.getClassContext().getLockDataflow(this.currentMethod);
            this.currentCFG = this.getClassContext().getCFG(this.currentMethod);
        }
        catch (CFGBuilderException e) {
            this.reporter.logError("Synchronization check in Static Calendar Detector caught an error.", (Throwable)e);
        }
        catch (DataflowAnalysisException e) {
            this.reporter.logError("Synchronization check in Static Calendar Detector caught an error.", (Throwable)e);
        }
    }

    public void sawOpcode(int seen) {
        if (seen != 182) {
            return;
        }
        try {
            OpcodeStack.Item passedAsArgument;
            String className = this.getClassConstantOperand();
            if (className.startsWith("[")) {
                return;
            }
            ObjectType tType = ObjectTypeFactory.getInstance((String)className);
            if (!tType.subclassOf(this.calendarType) && !tType.subclassOf(this.dateFormatType)) {
                return;
            }
            int numArguments = StaticCalendarDetector.getNumberArguments((String)this.getSigConstantOperand());
            OpcodeStack.Item invokedOn = this.stack.getStackItem(numArguments);
            XField field = invokedOn.getXField();
            if (field == null || !field.isStatic()) {
                return;
            }
            if (this.getMethodName().equals("<clinit>") && field.getClassName().equals(this.getDottedClassName())) {
                return;
            }
            if (this.getNameConstantOperand().equals("equals") && numArguments == 1 && ((field = (passedAsArgument = this.stack.getStackItem(0)).getXField()) == null || !field.isStatic())) {
                return;
            }
            if (!SystemProperties.getBoolean((String)PROP_SKIP_SYNCHRONIZED_CHECK)) {
                try {
                    if (this.currentMethod != null && this.currentLockDataFlow != null && this.currentCFG != null) {
                        Collection tLocations = this.currentCFG.getLocationsContainingInstructionWithOffset(this.getPC());
                        Iterator i$ = tLocations.iterator();
                        while (i$.hasNext()) {
                            Location tLoc = (Location)i$.next();
                            LockSet lockSet = this.currentLockDataFlow.getFactAtLocation(tLoc);
                            if (lockSet.getNumLockedObjects() <= 0) continue;
                            return;
                        }
                    }
                }
                catch (DataflowAnalysisException e) {
                    this.reporter.logError("Synchronization check in Static Calendar Detector caught an error.", (Throwable)e);
                }
            }
            String tBugType = null;
            if (tType.subclassOf(this.calendarType)) {
                tBugType = "STCAL_INVOKE_ON_STATIC_CALENDAR_INSTANCE";
            } else if (tType.subclassOf(this.dateFormatType)) {
                tBugType = "STCAL_INVOKE_ON_STATIC_DATE_FORMAT_INSTANCE";
            }
            if (tBugType != null) {
                this.reporter.reportBug(new BugInstance((Detector)this, tBugType, 2).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).addOptionalField(field).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
        }
    }
}

