/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log;

import java.util.Hashtable;
import org.eclipse.equinox.log.LogReaderService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LogEntryEventAdapter
implements LogListener,
ServiceTrackerCustomizer {
    public static final String TOPIC = "org/osgi/service/log/LogEntry";
    public static final char TOPIC_SEPARATOR = '/';
    public static final String LOG_ERROR = "LOG_ERROR";
    public static final String LOG_WARNING = "LOG_WARNING";
    public static final String LOG_INFO = "LOG_INFO";
    public static final String LOG_DEBUG = "LOG_DEBUG";
    public static final String LOG_OTHER = "LOG_OTHER";
    public static final String TIMESTAMP = "timestamp";
    public static final String MESSAGE = "message";
    public static final String LOG_LEVEL = "log.level";
    public static final String LOG_ENTRY = "log.entry";
    public static final String SERVICE = "service";
    public static final String SERVICE_ID = "service.id";
    public static final String SERVICE_OBJECTCLASS = "service.objectClass";
    public static final String SERVICE_PID = "service.pid";
    public static final String BUNDLE = "bundle";
    public static final String BUNDLE_ID = "bundle.id";
    public static final String BUNDLE_SYMBOLICNAME = "bundle.symbolicName";
    public static final String EVENT = "event";
    public static final String EXCEPTION = "exception";
    public static final String EXCEPTION_CLASS = "exception.class";
    public static final String EXCEPTION_MESSAGE = "exception.message";
    private BundleContext context;
    private volatile ServiceTracker eventAdminTracker;
    private ServiceTracker logReaderTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public LogEntryEventAdapter(BundleContext context) {
        this.context = context;
    }

    public void start() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.event.EventAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventAdminTracker = new ServiceTracker(this.context, clazz.getName(), null);
        this.eventAdminTracker.open();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.log.LogReaderService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logReaderTracker = new ServiceTracker(this.context, clazz2.getName(), (ServiceTrackerCustomizer)this);
        this.logReaderTracker.open();
    }

    public void stop() throws Exception {
        if (this.logReaderTracker != null) {
            this.logReaderTracker.close();
        }
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
        }
        this.context = null;
    }

    public void logged(LogEntry entry) {
        ServiceReference ref;
        EventAdmin eventAdmin = (EventAdmin)this.eventAdminTracker.getService();
        if (eventAdmin == null) {
            return;
        }
        String topic = TOPIC;
        int level = entry.getLevel();
        switch (level) {
            case 1: {
                topic = String.valueOf(topic) + "/LOG_ERROR";
                break;
            }
            case 2: {
                topic = String.valueOf(topic) + "/LOG_WARNING";
                break;
            }
            case 3: {
                topic = String.valueOf(topic) + "/LOG_INFO";
                break;
            }
            case 4: {
                topic = String.valueOf(topic) + "/LOG_DEBUG";
                break;
            }
            default: {
                topic = String.valueOf(topic) + "/LOG_OTHER";
            }
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Bundle bundle = entry.getBundle();
        if (bundle == null) {
            throw new RuntimeException("LogEntry.getBundle() returns null");
        }
        this.putBundleProperties(properties, bundle);
        Throwable t = entry.getException();
        if (t != null) {
            this.putExceptionProperties(properties, t);
        }
        if ((ref = entry.getServiceReference()) != null) {
            this.putServiceReferenceProperties(properties, ref);
        }
        properties.put(LOG_ENTRY, entry);
        properties.put(LOG_LEVEL, new Integer(entry.getLevel()));
        if (entry.getMessage() != null) {
            properties.put(MESSAGE, entry.getMessage());
        }
        properties.put(TIMESTAMP, new Long(entry.getTime()));
        Event convertedEvent = new Event(topic, properties);
        eventAdmin.postEvent(convertedEvent);
    }

    public void putServiceReferenceProperties(Hashtable properties, ServiceReference ref) {
        Object o2;
        properties.put(SERVICE, ref);
        properties.put(SERVICE_ID, ref.getProperty(SERVICE_ID));
        Object o = ref.getProperty(SERVICE_PID);
        if (o != null && o instanceof String) {
            properties.put(SERVICE_PID, o);
        }
        if ((o2 = ref.getProperty("objectClass")) != null && o2 instanceof String[]) {
            properties.put(SERVICE_OBJECTCLASS, o2);
        }
    }

    public void putBundleProperties(Hashtable properties, Bundle bundle) {
        properties.put(BUNDLE_ID, new Long(bundle.getBundleId()));
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            properties.put(BUNDLE_SYMBOLICNAME, symbolicName);
        }
        properties.put(BUNDLE, bundle);
    }

    public void putExceptionProperties(Hashtable properties, Throwable t) {
        properties.put(EXCEPTION, t);
        properties.put(EXCEPTION_CLASS, t.getClass().getName());
        String message = t.getMessage();
        if (message != null) {
            properties.put(EXCEPTION_MESSAGE, t.getMessage());
        }
    }

    public Object addingService(ServiceReference reference) {
        if (reference.getBundle() != this.context.getBundle()) {
            return null;
        }
        LogReaderService reader = (LogReaderService)this.context.getService(reference);
        reader.addLogListener(this);
        return reader;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        ((LogReaderService)service).removeLogListener(this);
    }
}

