/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util.threadpool;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.util.threadpool.Log4jThreadGroup;
import net.sourceforge.cruisecontrol.util.threadpool.ThreadQueueProperties;
import net.sourceforge.cruisecontrol.util.threadpool.WorkerThread;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadQueue
extends Thread {
    private static final Logger LOG = Logger.getLogger(ThreadQueue.class);
    private final ThreadGroup loggingGroup = new Log4jThreadGroup("Logging group", LOG);
    private final List<WorkerThread> idleTasks = Collections.synchronizedList(new LinkedList());
    private final List<WorkerThread> busyTasks = Collections.synchronizedList(new LinkedList());
    private final Map<String, Object> resultList = Collections.synchronizedMap(new HashMap());
    private final Map<WorkerThread, Thread> runningThreads = Collections.synchronizedMap(new HashMap());
    private final int threadCount = ThreadQueueProperties.getMaxThreadCount();
    private static final int SLEEP_TIME = 100;
    private static ThreadQueue threadQueue;

    @Override
    public void run() {
        while (true) {
            boolean maxedOut;
            boolean nothingWaiting = this.idleTasks.size() == 0;
            boolean bl = maxedOut = this.busyTasks.size() >= this.threadCount;
            if (nothingWaiting || maxedOut) {
                ThreadQueue.sleep(100);
            } else {
                this.handleWaitingTask();
            }
            this.cleanCompletedTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWaitingTask() {
        LOG.debug((Object)"handling waiting task");
        List<WorkerThread> list = this.busyTasks;
        synchronized (list) {
            List<WorkerThread> list2 = this.idleTasks;
            synchronized (list2) {
                WorkerThread firstIdleWorkerThread = this.idleTasks.get(0);
                if (ThreadQueue.getBusyTask(firstIdleWorkerThread.getName()) != null) {
                    LOG.debug((Object)"The idle task is already running, it will not be moved to busy tasks yet");
                    return;
                }
                this.idleTasks.remove(firstIdleWorkerThread);
                Thread thisThread = new Thread(this.loggingGroup, firstIdleWorkerThread);
                this.busyTasks.add(firstIdleWorkerThread);
                this.runningThreads.put(firstIdleWorkerThread, thisThread);
                thisThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCompletedTasks() {
        List<WorkerThread> list = this.busyTasks;
        synchronized (list) {
            Iterator<WorkerThread> tasks = this.busyTasks.iterator();
            while (tasks.hasNext()) {
                WorkerThread task = tasks.next();
                Object result = task.getResult();
                boolean taskDone = result != null;
                if (!taskDone) continue;
                LOG.debug((Object)"Found a finished task");
                LOG.debug((Object)("tempTask.getName() = " + task.getName()));
                LOG.debug((Object)("tempTask.getResult() = " + task.getResult()));
                this.resultList.put(task.getName(), result);
                tasks.remove();
                this.runningThreads.remove(task);
            }
        }
    }

    private static ThreadQueue getThreadQueue() {
        if (threadQueue == null) {
            threadQueue = new ThreadQueue();
            threadQueue.start();
        }
        return threadQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTask(WorkerThread task) {
        LOG.debug((Object)("Preparing to add worker task " + task.getName()));
        List<WorkerThread> list = ThreadQueue.getThreadQueue().busyTasks;
        synchronized (list) {
            List<WorkerThread> list2 = ThreadQueue.getThreadQueue().idleTasks;
            synchronized (list2) {
                ThreadQueue.getThreadQueue().cleanCompletedTasks();
                ThreadQueue.getThreadQueue().idleTasks.add(task);
            }
        }
    }

    public static String findPosition(String taskName) {
        WorkerThread task = ThreadQueue.getIdleTask(taskName);
        if (task != null) {
            return ThreadQueue.getTaskPosition(task, ThreadQueue.getThreadQueue().idleTasks, "IDLE");
        }
        task = ThreadQueue.getBusyTask(taskName);
        if (task != null) {
            return ThreadQueue.getTaskPosition(task, ThreadQueue.getThreadQueue().busyTasks, "BUSY");
        }
        Object result = ThreadQueue.getResult(taskName);
        if (result != null) {
            return "[ COMPLETE ]";
        }
        return "[ not found in queues ]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTaskPosition(WorkerThread task, List queue, String queueName) {
        int length;
        int position;
        List<WorkerThread> list = ThreadQueue.getThreadQueue().busyTasks;
        synchronized (list) {
            position = queue.indexOf(task);
            length = queue.size();
        }
        return ThreadQueue.formatPosition(position, length, queueName);
    }

    private static String formatPosition(int position, int length, String queueName) {
        if (position < 0) {
            return "[ NONE ]";
        }
        return queueName + "[ " + (position + 1) + " / " + length + " ]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActive(String taskName) {
        List<WorkerThread> list = ThreadQueue.getThreadQueue().busyTasks;
        synchronized (list) {
            return ThreadQueue.getBusyTask(taskName) != null || ThreadQueue.getIdleTask(taskName) != null;
        }
    }

    private static Object getResult(String workerName) {
        return ThreadQueue.getThreadQueue().resultList.get(workerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkerThread getBusyTask(String taskName) {
        List<WorkerThread> list = ThreadQueue.getThreadQueue().busyTasks;
        synchronized (list) {
            return ThreadQueue.getTask(taskName, ThreadQueue.getThreadQueue().busyTasks.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkerThread getIdleTask(String taskName) {
        List<WorkerThread> list = ThreadQueue.getThreadQueue().idleTasks;
        synchronized (list) {
            return ThreadQueue.getTask(taskName, ThreadQueue.getThreadQueue().idleTasks.iterator());
        }
    }

    private static WorkerThread getTask(String taskName, Iterator<WorkerThread> taskIter) {
        while (taskIter.hasNext()) {
            WorkerThread thisWorker = taskIter.next();
            String tempString = thisWorker.getName();
            if (!tempString.equalsIgnoreCase(taskName)) continue;
            return thisWorker;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getBusyTaskNames() {
        List<String> names;
        List<WorkerThread> list = ThreadQueue.getThreadQueue().busyTasks;
        synchronized (list) {
            names = ThreadQueue.getTaskNames(ThreadQueue.getThreadQueue().busyTasks.iterator());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getIdleTaskNames() {
        List<String> names;
        List<WorkerThread> list = ThreadQueue.getThreadQueue().busyTasks;
        synchronized (list) {
            names = ThreadQueue.getTaskNames(ThreadQueue.getThreadQueue().idleTasks.iterator());
        }
        return names;
    }

    private static List<String> getTaskNames(Iterator<WorkerThread> taskIter) {
        LinkedList<String> names = new LinkedList<String>();
        while (taskIter.hasNext()) {
            WorkerThread thisWorker = taskIter.next();
            names.add(thisWorker.getName());
        }
        return names;
    }

    private static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void stopQueue() {
        threadQueue.interrupt();
        threadQueue = null;
    }
}

