/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLogHelper {
    private final Element log;

    public XMLLogHelper(Element log) {
        this.log = log;
    }

    public String getLogFileName() throws CruiseControlException {
        return this.getCruiseControlInfoProperty("logfile");
    }

    public String getLabel() throws CruiseControlException {
        return this.getCruiseControlInfoProperty("label");
    }

    public String getBuildTimestamp() throws CruiseControlException {
        return this.getCruiseControlInfoProperty("cctimestamp");
    }

    public boolean wasPreviousBuildSuccessful() throws CruiseControlException {
        return this.getCruiseControlInfoProperty("lastbuildsuccessful").equals("true");
    }

    public boolean isBuildNecessary() {
        if (this.log.getChild("build") != null && this.log.getChild("build").getAttributeValue("error") != null) {
            return !this.log.getChild("build").getAttributeValue("error").equals("No Build Necessary");
        }
        return true;
    }

    public String getProjectName() throws CruiseControlException {
        return this.getCruiseControlInfoProperty("projectname");
    }

    public boolean isBuildSuccessful() {
        return this.log.getChild("build").getAttribute("error") == null;
    }

    public Set<String> getBuildParticipants() {
        HashSet<String> results = new HashSet<String>();
        for (Element modification : this.log.getChild("modifications").getChildren("modification")) {
            Element emailElement = modification.getChild("email");
            if (emailElement == null) {
                emailElement = modification.getChild("user");
            }
            results.add(emailElement.getText());
        }
        return results;
    }

    public String getAntProperty(String propertyName) throws CruiseControlException {
        Iterator props = this.log.getChild("build").getChild("properties").getChildren("property").iterator();
        return this.findProperty(props, propertyName);
    }

    private String findProperty(Iterator props, String expected) throws CruiseControlException {
        while (props.hasNext()) {
            Element property = (Element)props.next();
            if (!property.getAttributeValue("name").equals(expected)) continue;
            return property.getAttributeValue("value");
        }
        throw new CruiseControlException("Property: " + expected + " not found.");
    }

    public String getCruiseControlInfoProperty(String name) throws CruiseControlException {
        Iterator props = this.log.getChild("info").getChildren("property").iterator();
        return this.findProperty(props, name);
    }

    public Set<Modification> getModifications() {
        HashSet<Modification> results = new HashSet<Modification>();
        for (Element modification : this.log.getChild("modifications").getChildren("modification")) {
            Modification mod = new Modification();
            mod.fromElement(modification);
            results.add(mod);
        }
        return results;
    }

    public boolean isBuildFix() throws CruiseControlException {
        return !this.wasPreviousBuildSuccessful() && this.isBuildSuccessful();
    }
}

