/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.InputStream;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import net.sourceforge.cruisecontrol.util.StreamPumper;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class StreamLogger
implements StreamConsumer {
    private Logger logger;
    private Level level;

    private StreamLogger(Logger log, Level level) {
        this.logger = log;
        this.level = level;
    }

    public static StreamConsumer getInfoLogger(Logger log) {
        return new StreamLogger(log, Level.INFO);
    }

    public static StreamPumper getInfoPumper(Logger log, InputStream info) {
        return new StreamPumper(info, new StreamLogger(log, Level.INFO));
    }

    public static StreamPumper getInfoPumper(Logger log, Process process) {
        return StreamLogger.getInfoPumper(log, process.getInputStream());
    }

    public static StreamConsumer getWarnLogger(Logger log) {
        return new StreamLogger(log, Level.WARN);
    }

    public static StreamPumper getWarnPumper(Logger log, InputStream warn) {
        return new StreamPumper(warn, new StreamLogger(log, Level.WARN));
    }

    public static StreamPumper getWarnPumper(Logger log, Process process) {
        return StreamLogger.getWarnPumper(log, process.getErrorStream());
    }

    public void consumeLine(String line) {
        this.logger.log((Priority)this.level, (Object)line);
    }
}

