/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class PruneElementFilter
extends XMLFilterImpl {
    private static final Logger LOG = Logger.getLogger(PruneElementFilter.class);
    private final String tagName;
    private int depth = 0;

    public PruneElementFilter(String tagName) {
        this.tagName = tagName;
    }

    public PruneElementFilter(String tagName, XMLReader arg0) {
        super(arg0);
        this.tagName = tagName;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.isPruning()) {
            super.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.isPruning()) {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isPruning()) {
            --this.depth;
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.isPruning() && localName.equals(this.tagName)) {
            this.depth = 1;
            LOG.debug((Object)("pruning branch starting with element named " + this.tagName));
        } else if (this.isPruning()) {
            ++this.depth;
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    private boolean isPruning() {
        return this.depth > 0;
    }
}

