/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.IOException;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.Executor;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.RuntimeExecutor;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.StreamPumper;
import org.apache.log4j.Logger;

public final class Processes {
    private static final Logger LOG = Logger.getLogger(Processes.class);
    private static Executor runtime = new RuntimeExecutor();

    private Processes() {
    }

    public static void executeFully(Commandline c) throws IOException, InterruptedException {
        Process p = Processes.execute(c);
        p.waitFor();
        IO.close(p);
    }

    public static Process execute(Commandline c) throws IOException {
        Process p = runtime.exec(c);
        StreamPumper errorPumper = StreamLogger.getWarnPumper(LOG, p);
        new Thread((Runnable)errorPumper, "ProcessThread_" + c.getExecutable()).start();
        return p;
    }

    public static int waitFor(Process proc, Logger log) throws IOException, InterruptedException {
        return Processes.waitFor(proc, StreamLogger.getInfoLogger(log), StreamLogger.getWarnLogger(log));
    }

    public static int waitFor(Process proc, StreamConsumer output, StreamConsumer error) throws IOException, InterruptedException {
        proc.getOutputStream().close();
        Thread stderr = new Thread(new StreamPumper(proc.getErrorStream(), error));
        stderr.start();
        new StreamPumper(proc.getInputStream(), output).run();
        int exitValue = proc.waitFor();
        stderr.join();
        return exitValue;
    }

    static void setRuntime(Executor e) {
        runtime = e;
    }
}

