/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSEnvironment {
    private static final Logger LOG = Logger.getLogger(OSEnvironment.class);
    private final Properties variables = new Properties();

    public OSEnvironment() {
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        String os = System.getProperty("os.name").toLowerCase();
        String command = this.isWindows9x(os) ? "command.com /c set" : (os.indexOf("nt") > -1 || os.indexOf("windows") > -1 || os.indexOf("os/2") > -1 ? "cmd.exe /c set" : "env");
        try {
            Process p = Runtime.getRuntime().exec(command);
            p.getOutputStream().close();
            BufferedReader stdoutStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stderrStream = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            try {
                String line;
                String key = null;
                while ((line = stdoutStream.readLine()) != null) {
                    String value;
                    int idx = line.indexOf(61);
                    if (idx == -1) {
                        if (key == null) continue;
                        value = this.variables.getProperty(key);
                        value = value + "\n" + line;
                    } else {
                        key = line.substring(0, idx);
                        value = line.substring(idx + 1);
                    }
                    this.variables.setProperty(key, value);
                }
            }
            finally {
                stdoutStream.close();
                stderrStream.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to parse the OS environment.", (Throwable)e);
        }
    }

    private boolean isWindows9x(String os) {
        return os.indexOf("windows 9") > -1;
    }

    public String getVariable(String variable) {
        return this.variables.getProperty(variable);
    }

    public String getVariable(String variable, String defaultValue) {
        return this.variables.getProperty(variable, defaultValue);
    }

    public String getVariableIgnoreCase(String variable) {
        Enumeration<Object> keys = this.variables.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.equalsIgnoreCase(variable)) continue;
            return this.variables.getProperty(key);
        }
        return null;
    }

    public void add(String variable, String value) {
        this.variables.setProperty(variable, value);
    }

    public List<String> getEnvironment() {
        ArrayList<String> env = new ArrayList<String>();
        Enumeration<Object> keys = this.variables.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            env.add(key + "=" + this.variables.getProperty(key));
        }
        return env;
    }

    public String[] toArray() {
        List<String> list = this.getEnvironment();
        return list.toArray(new String[list.size()]);
    }

    public String toString() {
        return this.variables.toString();
    }
}

