/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.EnvCommandline;
import org.apache.log4j.Logger;

public class ManagedCommandline
extends EnvCommandline {
    private static final Logger LOG = Logger.getLogger(ManagedCommandline.class);
    private int exitCode;
    private String stdout;
    private List stdoutLines = new ArrayList();
    private String stderr;
    private List stderrLines = new ArrayList();

    public ManagedCommandline(String command) {
        super(command);
    }

    public ManagedCommandline() {
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getStdoutAsString() {
        return this.stdout;
    }

    public List getStdoutAsList() {
        return this.stdoutLines;
    }

    public String getStderrAsString() {
        return this.stderr;
    }

    public List getStderrAsList() {
        return this.stderrLines;
    }

    public void clear() {
        super.clear();
        this.clearArgs();
    }

    public void clearArgs() {
        this.exitCode = -1;
        this.stdout = "";
        this.stderr = "";
        this.stdoutLines.clear();
        this.stderrLines.clear();
        super.clearArgs();
    }

    public void assertStdoutDoesNotContain(String string) throws CruiseControlException {
        if (this.stdout.indexOf(string) > -1) {
            throw new CruiseControlException("The command \"" + this.toString() + "\" returned the forbidden string \"" + string + "\". \n" + "Stdout: " + this.stdout + "Stderr: " + this.stderr);
        }
    }

    public void assertStdoutContains(String string) throws CruiseControlException {
        if (this.stdout.indexOf(string) < 0) {
            throw new CruiseControlException("The stdout of the command \"" + this.toString() + "\" did not contain the required string \"" + string + "\". \n" + "Stdout: " + this.stdout + "Stderr: " + this.stderr);
        }
    }

    public void assertStderrDoesNotContain(String string) throws CruiseControlException {
        if (this.stderr.indexOf(string) > -1) {
            throw new CruiseControlException("The command \"" + this.toString() + "\" returned the forbidden string \"" + string + "\". \n" + "Stdout: " + this.stdout + "Stderr: " + this.stderr);
        }
    }

    public void assertExitCode(int code) throws CruiseControlException {
        if (this.exitCode != code) {
            throw new CruiseControlException("The command \"" + this.toString() + "\" returned exit code \"" + this.exitCode + "\" when \"" + code + "\" was expected.\n" + "Stdout: " + this.stdout + "Stderr: " + this.stderr);
        }
    }

    public void assertExitCodeNot(int code) throws CruiseControlException {
        if (this.exitCode == code) {
            throw new CruiseControlException("The command \"" + this.toString() + "\" returned exit code \"" + this.exitCode + "\".\n" + "Stdout: " + this.stdout + "Stderr: " + this.stderr);
        }
    }

    public void assertExitCodeGreaterThan(int code) throws CruiseControlException {
        if (this.exitCode <= code) {
            throw new CruiseControlException("The command \"" + this.toString() + "\" returned exit code \"" + this.exitCode + "\" when a value greater than \"" + code + "\" was expected.\n" + "Stdout: " + this.stdout + "Stderr: " + this.stderr);
        }
    }

    public void assertExitCodeLessThan(int code) throws CruiseControlException {
        if (this.exitCode >= code) {
            throw new CruiseControlException("The command \"" + this.toString() + "\" returned exit code \"" + this.exitCode + "\" when a value less than \"" + code + "\" was expected.\n" + "Stdout: " + this.stdout + "Stderr: " + this.stderr);
        }
    }

    public Process execute() throws IOException {
        String line;
        Process proc = super.execute();
        BufferedReader stdoutStream = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader stderrStream = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        StringBuffer buff = new StringBuffer();
        while ((line = stdoutStream.readLine()) != null) {
            this.stdoutLines.add(line);
            buff.append(line).append('\n');
        }
        this.stdout = buff.toString();
        buff.setLength(0);
        while ((line = stderrStream.readLine()) != null) {
            this.stderrLines.add(line);
            buff.append(line).append('\n');
        }
        this.stderr = buff.toString();
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Thread was interrupted while executing command \"" + this.toString() + "\"."), (Throwable)e);
        }
        stdoutStream.close();
        stderrStream.close();
        this.exitCode = proc.exitValue();
        return proc;
    }
}

