/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

public final class MainArgs {
    public static final int NOT_FOUND = -1;

    private MainArgs() {
    }

    public static int parseInt(String[] args, String argName, int defaultIfNoParam, int defaultIfNoValue) {
        String intString = MainArgs.parseArgument(args, argName, Integer.toString(defaultIfNoParam), Integer.toString(defaultIfNoValue));
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("-" + argName + " parameter, specified as '" + intString + "', requires integer argument");
        }
    }

    public static String parseArgument(String[] args, String argName, String defaultIfNoParam, String defaultIfNoValue) {
        int argIndex = MainArgs.findIndex(args, argName);
        if (argIndex == -1) {
            return defaultIfNoParam;
        }
        if (argIndex == args.length - 1 || args[argIndex + 1].charAt(0) == '-') {
            return defaultIfNoValue;
        }
        return args[argIndex + 1];
    }

    public static int findIndex(String[] args, String argName) {
        String searchString = "-" + argName;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(searchString)) continue;
            return i;
        }
        return -1;
    }

    public static boolean argumentPresent(String[] args, String argName) {
        return MainArgs.findIndex(args, argName) != -1;
    }

    public static boolean parseBoolean(String[] args, String argName, boolean defaultIfNoParam, boolean defaultIfNoValue) {
        String booleanString = MainArgs.parseArgument(args, argName, Boolean.toString(defaultIfNoParam), Boolean.toString(defaultIfNoValue));
        try {
            return Boolean.valueOf(booleanString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("-" + argName + " parameter, specified as '" + booleanString + "', requires boolean argument");
        }
    }
}

