/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class IO {
    private IO() {
    }

    public static void close(OutputStream o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream i) {
        if (i != null) {
            try {
                i.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer w) {
        if (w != null) {
            try {
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Process p) {
        try {
            IO.close(p.getInputStream());
            IO.close(p.getOutputStream());
            IO.close(p.getErrorStream());
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    public static void output(File to, Element xml, String encoding) throws CruiseControlException {
        BufferedOutputStream logStream = null;
        try {
            Format format = Format.getPrettyFormat();
            if (encoding != null) {
                format.setEncoding(encoding);
            }
            XMLOutputter outputter = new XMLOutputter(format);
            logStream = new BufferedOutputStream(new FileOutputStream(to));
            outputter.output(new Document(xml), (OutputStream)logStream);
        }
        catch (IOException e) {
            try {
                throw new CruiseControlException(e);
            }
            catch (Throwable throwable) {
                IO.close(logStream);
                throw throwable;
            }
        }
        IO.close(logStream);
    }

    public static void delete(File f) {
        if (f == null || !f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            IO.deleteDir(f);
            return;
        }
        f.delete();
    }

    private static void deleteDir(File dir) {
        File[] children = dir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            IO.delete(child);
        }
        dir.delete();
    }

    public static void delete(File f, boolean debuggerOn, Logger log) {
        try {
            IO.delete(f);
            if (debuggerOn) {
                log.info((Object)("Removed temp file " + f.getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void dumpTo(File f, PrintStream out) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f));
            while (in.ready()) {
                out.println(in.readLine());
            }
        }
        catch (Exception exception) {
            IO.close(in);
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close(in);
    }

    public static void write(String fileName, String content) throws CruiseControlException {
        IO.write(new File(fileName), content);
    }

    public static void write(File f, String contents) throws CruiseControlException {
        FileWriter fw = null;
        try {
            if (f.getParentFile() != null) {
                f.getParentFile().mkdirs();
            }
            fw = new FileWriter(f);
            fw.write(contents);
        }
        catch (IOException ioe) {
            try {
                throw new CruiseControlException("Error writing file: " + f.getAbsolutePath(), ioe);
            }
            catch (Throwable throwable) {
                IO.close(fw);
                throw throwable;
            }
        }
        IO.close(fw);
    }

    public static List readLines(File source) throws CruiseControlException {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(source));
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        catch (IOException ioe) {
            try {
                throw new CruiseControlException("Error reading file: " + source.getAbsolutePath(), ioe);
            }
            catch (Throwable throwable) {
                IO.close(reader);
                throw throwable;
            }
        }
        IO.close(reader);
        return result;
    }
}

