/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class EmptyElementFilter
extends XMLFilterImpl {
    private static final Logger LOG = Logger.getLogger(EmptyElementFilter.class);
    private final String tagName;
    private boolean checkingTag = false;
    private String messageUri;
    private String messageQName;
    private Attributes messageAtts;

    public EmptyElementFilter(String tagName) {
        this.tagName = tagName;
    }

    public EmptyElementFilter(String tagName, XMLReader arg0) {
        super(arg0);
        this.tagName = tagName;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.checkingTag) {
            this.cancelCheck();
        }
        super.characters(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.checkingTag) {
            this.checkingTag = false;
            LOG.debug((Object)("Skipping empty <" + localName + ">-tag"));
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.checkingTag) {
            this.cancelCheck();
        }
        if (localName.equals(this.tagName)) {
            this.checkingTag = true;
            this.messageUri = uri;
            this.messageQName = qName;
            this.messageAtts = atts;
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    private void cancelCheck() throws SAXException {
        super.startElement(this.messageUri, this.tagName, this.messageQName, this.messageAtts);
        this.checkingTag = false;
    }
}

