/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.sourceforge.cruisecontrol.CruiseControlException;
import org.apache.tools.ant.util.DateUtils;

public final class DateUtil {
    public static final SimpleDateFormat ISO8601_DATE_FORMATTER;
    public static final transient long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    static final long ONE_HOUR = 3600000L;
    public static final String SIMPLE_DATE_FORMAT = "yyyyMMddHHmmss";
    private static final SimpleDateFormat SIMPLE_DATE_FORMATTER;

    private DateUtil() {
    }

    public static int getTimeFromDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = calendar.get(11) * 100;
        int minute = calendar.get(12);
        return hour + minute;
    }

    public static long milliTimeDifference(int earlier, int later) {
        long earlierMillis = DateUtil.convertToMillis(earlier);
        long laterMillis = DateUtil.convertToMillis(later);
        return laterMillis - earlierMillis;
    }

    public static long convertToMillis(int hhmm) {
        int minutes = hhmm % 100;
        int hours = (hhmm - minutes) / 100;
        return (long)hours * 3600000L + (long)minutes * 60000L;
    }

    public static String formatTime(long time) {
        long seconds = time / 1000L;
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        seconds %= 60L;
        StringBuilder sb = new StringBuilder();
        if (hours != 0L) {
            sb.append(hours).append(" hours ");
        }
        if (minutes != 0L) {
            sb.append(minutes).append(" minutes ");
        }
        if (seconds != 0L) {
            sb.append(seconds).append(" seconds");
        }
        return sb.toString();
    }

    public static Date getMidnight() {
        Calendar midnight = Calendar.getInstance();
        midnight.set(11, 0);
        midnight.set(12, 0);
        midnight.set(13, 0);
        midnight.set(14, 0);
        return midnight.getTime();
    }

    public static String getFormattedTime(Date date) {
        if (date == null) {
            return null;
        }
        return SIMPLE_DATE_FORMATTER.format(date);
    }

    public static Date parseFormattedTime(String timeString, String description) throws CruiseControlException {
        Date date;
        if (timeString == null) {
            throw new IllegalArgumentException("Null date string for " + description);
        }
        try {
            date = SIMPLE_DATE_FORMATTER.parse(timeString);
        }
        catch (ParseException e) {
            throw new CruiseControlException("Cannot parse string for " + description + ":" + timeString);
        }
        return date;
    }

    public static String getDurationAsString(long buildLength) {
        long timeSeconds = buildLength / 1000L;
        long minutes = timeSeconds / 60L;
        long seconds = timeSeconds - minutes * 60L;
        return minutes + " minute(s) " + seconds + " second(s)";
    }

    public static Date parseIso8601(String timestamp) throws ParseException {
        return ISO8601_DATE_FORMATTER.parse(timestamp);
    }

    public static String formatIso8601(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss");
    }

    static {
        SIMPLE_DATE_FORMATTER = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        ISO8601_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        ISO8601_DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone("GMT -0:00"));
    }
}

