/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.CommandExecutor;
import net.sourceforge.cruisecontrol.util.CruiseRuntime;
import net.sourceforge.cruisecontrol.util.Directory;
import org.apache.log4j.Logger;

public class Commandline
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(Commandline.class);
    private Vector arguments = new Vector();
    private String executable = null;
    private File workingDir = null;
    private final CruiseRuntime runtime;
    private boolean safeQuoting = true;

    public Commandline(String toProcess, CruiseRuntime cruiseRuntime) {
        this.runtime = cruiseRuntime;
        if (toProcess != null) {
            String[] tmp = new String[]{};
            try {
                tmp = Commandline.translateCommandline(toProcess);
            }
            catch (CruiseControlException e) {
                LOG.error((Object)"Error translating Commandline.", (Throwable)e);
            }
            if (tmp != null && tmp.length > 0) {
                this.setExecutable(tmp[0]);
                for (int i = 1; i < tmp.length; ++i) {
                    this.createArgument().setValue(tmp[i]);
                }
            }
        }
    }

    public Commandline(String toProcess) {
        this(toProcess, new CruiseRuntime());
    }

    public Commandline() {
        this(null);
    }

    protected File getWorkingDir() {
        return this.workingDir;
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Argument createArgument(boolean insertAtStart) {
        Argument argument = new Argument();
        if (insertAtStart) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public Argument createArgument(String value) {
        Argument arg = this.createArgument();
        arg.setValue(value);
        return arg;
    }

    public void createArguments(String first, String second) {
        this.createArgument(first);
        this.createArgument(second);
    }

    public void setExecutable(String executable) {
        if (executable == null || executable.length() == 0) {
            return;
        }
        this.executable = executable.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void addArguments(String[] line) {
        for (int i = 0; i < line.length; ++i) {
            this.createArgument().setValue(line[i]);
        }
    }

    public String[] getCommandline() {
        String[] args = this.getArguments();
        if (this.executable == null) {
            return args;
        }
        String[] result = new String[args.length + 1];
        result[0] = this.executable;
        System.arraycopy(args, 0, result, 1, args.length);
        return result;
    }

    public String[] getArguments() {
        Vector<String> result = new Vector<String>(this.arguments.size() * 2);
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument arg = (Argument)this.arguments.elementAt(i);
            String[] s = arg.getParts();
            if (s == null) continue;
            for (int j = 0; j < s.length; ++j) {
                result.addElement(s[j]);
            }
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline(), true);
    }

    public String toStringNoQuoting() {
        return Commandline.toString(this.getCommandline(), false);
    }

    public static String quoteArgument(String argument) throws CruiseControlException {
        if (argument.indexOf("\"") > -1) {
            if (argument.indexOf("'") > -1) {
                throw new CruiseControlException("Can't handle single and double quotes in same argument");
            }
            return '\'' + argument + '\'';
        }
        if (argument.indexOf("'") > -1 || argument.indexOf(" ") > -1) {
            return '\"' + argument + '\"';
        }
        return argument;
    }

    public static String toString(String[] line, boolean quote) {
        return Commandline.toString(line, quote, " ");
    }

    public static String toString(String[] line, boolean quote, String separator) {
        if (line == null || line.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < line.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            if (quote) {
                try {
                    result.append(Commandline.quoteArgument(line[i]));
                }
                catch (CruiseControlException e) {
                    LOG.error((Object)"Error quoting argument.", (Throwable)e);
                }
                continue;
            }
            result.append(line[i]);
        }
        return result.toString();
    }

    public static String[] translateCommandline(String toProcess) throws CruiseControlException {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        Vector<String> v = new Vector<String>();
        StringBuffer current = new StringBuffer();
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
                continue;
            }
            if ("\"".equals(nextTok)) {
                state = 2;
                continue;
            }
            if (" ".equals(nextTok)) {
                if (current.length() == 0) continue;
                v.addElement(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(nextTok);
        }
        if (current.length() != 0) {
            v.addElement(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new CruiseControlException("unbalanced quotes in " + toProcess);
        }
        Object[] args = new String[v.size()];
        v.copyInto(args);
        return args;
    }

    public int size() {
        return this.getCommandline().length;
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        Commandline c = new Commandline();
        c.setExecutable(this.executable);
        c.addArguments(this.getArguments());
        c.useSafeQuoting(this.safeQuoting);
        return c;
    }

    public void clear() {
        this.executable = null;
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public void setWorkingDirectory(String path) throws CruiseControlException {
        if (path != null) {
            File dir = new File(path);
            this.checkWorkingDir(dir);
            this.workingDir = dir;
        } else {
            this.workingDir = null;
        }
    }

    public void useSafeQuoting(boolean safe) {
        this.safeQuoting = safe;
    }

    public void setWorkingDir(Directory directory) throws CruiseControlException {
        directory.validate();
        this.workingDir = directory.toFile();
    }

    public void setWorkingDir(File workingDir) throws CruiseControlException {
        this.checkWorkingDir(workingDir);
        this.workingDir = workingDir;
    }

    private void checkWorkingDir(File dir) throws CruiseControlException {
        if (dir != null) {
            if (!dir.exists()) {
                throw new CruiseControlException("Working directory \"" + dir.getAbsolutePath() + "\" does not exist!");
            }
            if (!dir.isDirectory()) {
                throw new CruiseControlException("Path \"" + dir.getAbsolutePath() + "\" does not specify a " + "directory.");
            }
        }
    }

    public File getWorkingDirectory() {
        return this.workingDir;
    }

    public Process execute() throws IOException {
        Process process;
        String msgCommandInfo = "Executing: [" + this.getExecutable() + "] with parameters: [" + Commandline.toString(this.getCommandline(), false, "], [") + "]";
        if (this.workingDir == null) {
            LOG.debug((Object)msgCommandInfo);
            process = this.safeQuoting ? this.runtime.exec(this.getCommandline()) : this.runtime.exec(this.toStringNoQuoting());
        } else {
            LOG.debug((Object)(msgCommandInfo + " in directory " + this.workingDir.getAbsolutePath()));
            process = this.safeQuoting ? this.runtime.exec(this.getCommandline(), null, this.workingDir) : this.runtime.exec(this.toStringNoQuoting(), null, this.workingDir);
        }
        process.getOutputStream().close();
        return process;
    }

    public void executeAndWait(Logger log) throws CruiseControlException {
        new CommandExecutor(this, log).executeAndWait();
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int position) {
            this.position = position;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = Commandline.this.executable == null ? 0 : 1;
                for (int i = 0; i < this.position; ++i) {
                    Argument arg = (Argument)Commandline.this.arguments.elementAt(i);
                    this.realPos += arg.getParts().length;
                }
            }
            return this.realPos;
        }
    }

    public static class Argument {
        private String[] parts;

        public void setValue(String value) {
            this.parts = new String[]{value};
        }

        public void setLine(String line) {
            if (line == null) {
                return;
            }
            try {
                this.parts = Commandline.translateCommandline(line);
            }
            catch (CruiseControlException e) {
                LOG.error((Object)"Error translating Commandline.", (Throwable)e);
            }
        }

        public void setFile(File value) {
            this.parts = new String[]{value.getAbsolutePath()};
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

