/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class CVSDateUtil {
    private static final String CVS_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss 'GMT'";
    private static final String NEW_CVS_DATE_PATTERN = "yyyy/MM/dd HH:mm:ss 'GMT'";
    private static final TimeZone UTC = TimeZone.getTimeZone("Etc/UTC");

    private CVSDateUtil() {
    }

    public static String formatCVSDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(CVS_DATE_PATTERN);
        format.setTimeZone(UTC);
        return format.format(date);
    }

    public static Date parseCVSDate(String text) throws ParseException {
        Date returnDate;
        try {
            SimpleDateFormat format = new SimpleDateFormat(CVS_DATE_PATTERN);
            format.setTimeZone(UTC);
            returnDate = format.parse(text);
        }
        catch (ParseException e) {
            SimpleDateFormat format = new SimpleDateFormat(NEW_CVS_DATE_PATTERN);
            format.setTimeZone(UTC);
            returnDate = format.parse(text);
        }
        return returnDate;
    }
}

