/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.IO;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public abstract class AbstractFTPClass {
    private static final Logger LOG = Logger.getLogger(AbstractFTPClass.class);
    private String targetHost;
    private int targetPort = 21;
    private String targetUser = "anonymous";
    private String targetPasswd = "eat@joes.com";
    private String targetDir = ".";
    private String targetSeparator = "/";
    private boolean passive = false;

    public void setTargetUser(String targetUser) {
        this.targetUser = targetUser;
    }

    public void setTargetHost(String targetHost) {
        this.targetHost = targetHost;
    }

    public void setTargetPort(int targetPort) {
        this.targetPort = targetPort;
    }

    public void setTargetPasswd(String targetPasswd) {
        this.targetPasswd = targetPasswd;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    public void setTargetSeparator(String targetSeparator) {
        this.targetSeparator = targetSeparator;
    }

    public void setPassive(boolean p) {
        this.passive = p;
    }

    public void validate() throws CruiseControlException {
        if (this.targetHost == null) {
            throw new CruiseControlException("'targethost' not specified in configuration file");
        }
        if (this.targetDir == null) {
            this.targetDir = ".";
        }
    }

    protected FTPClient openFTP() throws CruiseControlException {
        LOG.info((Object)("Opening FTP connection to " + this.targetHost));
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(this.targetHost, this.targetPort);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                throw new CruiseControlException("FTP connection failed: " + ftp.getReplyString());
            }
            LOG.info((Object)"logging in to FTP server");
            if (!ftp.login(this.targetUser, this.targetPasswd)) {
                throw new CruiseControlException("Could not login to FTP server");
            }
            LOG.info((Object)"login succeeded");
            if (this.passive) {
                this.setPassive(ftp);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
            throw new CruiseControlException(ioe.getMessage());
        }
        return ftp;
    }

    protected void closeFTP(FTPClient ftp) {
        if (ftp != null && ftp.isConnected()) {
            try {
                LOG.info((Object)"disconnecting");
                ftp.logout();
                ftp.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void setBinary(FTPClient ftp) throws CruiseControlException {
        try {
            ftp.setFileType(2);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                throw new CruiseControlException("could not set transfer type: " + ftp.getReplyString());
            }
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw new CruiseControlException(ex.getMessage());
        }
    }

    private void setPassive(FTPClient ftp) throws CruiseControlException {
        LOG.info((Object)"entering passive mode");
        ftp.enterLocalPassiveMode();
        if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
            throw new CruiseControlException("could not enter into passive mode: " + ftp.getReplyString());
        }
    }

    protected void makeDir(FTPClient ftp, String dir, boolean ignoreFailures) throws CruiseControlException {
        dir = this.targetDir + this.targetSeparator + dir;
        try {
            if (!ftp.makeDirectory(dir)) {
                int rc = ftp.getReplyCode();
                if (!ignoreFailures || rc != 550 && rc != 553 && rc != 521) {
                    throw new CruiseControlException("could not create directory: " + ftp.getReplyString());
                }
                LOG.info((Object)"directory already exists");
            } else {
                LOG.info((Object)"directory created OK");
            }
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw new CruiseControlException(ex.getMessage());
        }
    }

    protected void sendFile(FTPClient ftp, File infile, String outfilename) throws CruiseControlException {
        BufferedInputStream instream = null;
        try {
            LOG.info((Object)("transferring " + infile.getAbsolutePath()));
            instream = new BufferedInputStream(new FileInputStream(infile));
            this.sendStream(ftp, instream, outfilename);
        }
        catch (IOException ioe) {
            try {
                throw new CruiseControlException(ioe.getMessage());
            }
            catch (Throwable throwable) {
                IO.close(instream);
                throw throwable;
            }
        }
        IO.close(instream);
    }

    protected void sendStream(FTPClient ftp, InputStream instream, String outfilename) throws CruiseControlException {
        LOG.info((Object)("transferring to file " + outfilename));
        outfilename = this.targetDir + this.targetSeparator + this.resolveFile(outfilename);
        try {
            ftp.storeFile(outfilename, instream);
            boolean success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
            if (!success) {
                throw new CruiseControlException("could not put file: " + ftp.getReplyString());
            }
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw new CruiseControlException(ex.getMessage());
        }
    }

    protected String resolveFile(String file) {
        return file.replace(File.separatorChar, this.targetSeparator.charAt(0));
    }

    protected void makeDirsForFile(FTPClient ftp, String filename, Vector knownPaths) throws CruiseControlException {
        String fname = this.resolveFile(filename);
        LOG.info((Object)("making dirs for file " + fname));
        int pos = fname.lastIndexOf(this.targetSeparator);
        if (pos > 0) {
            this.makeDirs(ftp, fname.substring(0, pos), knownPaths);
        }
    }

    protected void makeDirs(FTPClient ftp, String pathname, Vector knownPaths) throws CruiseControlException {
        if (knownPaths == null) {
            knownPaths = new Vector<String>();
        }
        StringTokenizer st = new StringTokenizer(this.targetDir + this.targetSeparator + this.resolveFile(pathname), this.targetSeparator, false);
        try {
            String cwd = ftp.printWorkingDirectory();
            LOG.info((Object)("makeDirs: current dir = " + cwd));
            String fullPath = this.targetDir;
            while (st.hasMoreTokens()) {
                String dir = st.nextToken();
                if (dir == null || dir.length() <= 0) continue;
                fullPath = fullPath + this.targetSeparator + dir;
                LOG.info((Object)("makeDirs: dir = " + dir + ", fullPath = " + fullPath));
                if (!ftp.changeWorkingDirectory(dir)) {
                    LOG.info((Object)("makeDirs: could not CD into " + dir));
                    if (!ftp.makeDirectory(dir)) {
                        throw new CruiseControlException("could not create directory [" + dir + ", full=" + fullPath + "]: " + ftp.getReplyString());
                    }
                    LOG.info((Object)("makeDirs: created dir " + dir));
                    if (!ftp.changeWorkingDirectory(dir)) {
                        throw new CruiseControlException("could not change to directory: " + ftp.getReplyString());
                    }
                    LOG.info((Object)("makeDirs: CDed into " + dir));
                }
                knownPaths.addElement(fullPath);
            }
            ftp.changeWorkingDirectory(cwd);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw new CruiseControlException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFileToFTPPath(String text, String path) throws CruiseControlException {
        ByteArrayInputStream bais = new ByteArrayInputStream(text.getBytes());
        FTPClient ftp = this.openFTP();
        try {
            this.makeDirsForFile(ftp, path, null);
            this.sendStream(ftp, bais, path);
        }
        finally {
            this.closeFTP(ftp);
        }
    }
}

